package cn.myapps.message.notice.service;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.notice.dao.NoticeDAO;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notification.dao.NotificationDAO;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Service
public class NoticeProcessBean implements BaseProcess<Notice>, NoticeProcess {

	@Autowired
	private NoticeDAO noticeDAO;

	@Autowired
	private NotificationDAO notificationDAO;

	@Autowired
	private JdbcTemplate jdbcTemplate;

	@Override
	public Notice doCreate(Notice vo) throws Exception {
		return noticeDAO.save(vo);
	}

	/**
	 * description：批量创建消息
	 * author：linchunpeng
	 * date：2025/6/30
	 */
	@Override
	public List<Notice> doCreateList(List<Notice> voList) {
		return noticeDAO.saveAll(voList);
	}

	@Override
	public Notice findNoticeById(String noticeId, String userId) throws Exception {
		Notice notice = null;
		try {
			notice = noticeDAO.findById(noticeId).orElse(notice);
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
		return notice;
	}

	@Override
	public DataPackage<Notice> queryNoticeByCondition(String summary, Boolean readStatus,
													  Collection<Integer> subjectTypes, int page,
													  int lines, String userId) throws Exception {
		DataPackage<Notice> dp = new DataPackage<Notice>();
		dp.setPageNo(page);
		dp.setLinesPerPage(lines);
		Pageable pageable = PageRequest.of(page-1, lines);
		Specification specification = new Specification<Notice>() {
			@Override
			public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				List<Predicate> predicates = new ArrayList<>();
				if (userId != null && !userId.equals("")) {
					predicates.add(cb.equal(root.get("toUserId"),userId));
				}
				if(readStatus != null){
					if(readStatus){
						predicates.add(cb.equal(root.get("read"),1));
					}else {
						predicates.add(cb.equal(root.get("read"),0));
					}

				}
				if(!CollectionUtils.isEmpty(subjectTypes)) {
					CriteriaBuilder.In subjectTypesInClause = cb.in(root.get("subjectType"));
					for (Integer iValue : subjectTypes) {
						subjectTypesInClause.value(iValue);
					}

					predicates.add(subjectTypesInClause);
				}

				if(!StringUtil.isBlank(summary)){
					predicates.add(cb.like(root.get("summary"),"%"+summary+"%"));
				}
				Predicate[] pre = new Predicate[predicates.size()];
				query.where(predicates.toArray(pre));
				query.orderBy(cb.desc(root.get("createTime")));
				return cb.and(predicates.toArray(pre));
			}
		};
		Page<Notice> all = noticeDAO.findAll(specification, pageable);
		long count = noticeDAO.count(specification);
		dp.setDatas(all.getContent());
		dp.setRowCount((int) count);

		return dp;
	}

	@Override
	public void setNotice2Read(String noticesId) throws Exception {
		try {
			if(!StringUtil.isBlank(noticesId)){
				for(String id : noticesId.split(",")){
					noticeDAO.setNotice2Read(id);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	@Override
	public void markAllAsRead(String receiverId) throws Exception {
		try {
			noticeDAO.markAllAsRead(receiverId);
			notificationDAO.deleteAllByMessageId(receiverId);
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}

	@Override
	public void removeByDocId(String docId, String userId) throws Exception {
		DataPackage<Notice> noticeDatas = queryNoticeByCondition(null, null, Collections.EMPTY_LIST, 1, Integer.MAX_VALUE, userId);
		for (Iterator<Notice> iterator = noticeDatas.datas.iterator(); iterator.hasNext();) {
			Notice notice = (Notice) iterator.next();

			JSONObject json = JSONObject.fromObject(notice.getLinkParams());
			String noticeDocId = (String) json.get("_docid");
			if (docId.equals(noticeDocId)) {
				noticeDAO.deleteById(notice.getId());
			}
		}
	}

	@Override
	public List<Map<String, Object>> queryModuleNoticeByCondition(String summary, Boolean readStatus,  String userId) throws Exception {
		Collection<Object> params = new ArrayList<>();
		params.add(userId);

		String sql =
				"SELECT a.MODULE as module,a.SUMMARY as summary,GROUP_CONCAT(DISTINCT a.SUBJECT_TYPE) as subjectType,SUM((case when IS_READ=0 then 1 else 0 end)) as countOfUnread  FROM mc_notice a where a.TO_USER_ID=?";
		if (!StringUtil.isBlank(summary)) {
			sql += " and a.SUMMARY like concat('%', ?, '%')";
			params.add(summary);
		}
/*
		if (readStatus != null) {
			sql += " and a.IS_READ = ?";
			params.add(readStatus ? 1 : 0);
		}
 */

		sql += " GROUP BY a.MODULE order by a.CREATE_TIME desc";
		List<Map<String, Object>> result =
				jdbcTemplate.queryForList(sql, params.toArray());
		return result;
	}

	@Override
	public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
		return null;
	}

	@Override
	public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
		return null;
	}

	@Override
	public AuthtimeValueObject doView(String pk) throws Exception {
		return null;
	}

	@Override
	public void doRemove(String pk) throws Exception {
		noticeDAO.deleteById(pk);
	}

	@Override
	public void doRemove(String[] pk) throws Exception {

	}

	@Override
	public DataPackage<Notice> doQuery(ParamsTable params, IUser user) throws Exception {
		return null;
	}


}
