package cn.myapps.message.notice.service;

import cn.myapps.common.data.DataPackage;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.notice.model.Notice;

import java.util.List;

import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface NoticeProcess extends BaseProcess<Notice> {

	public Notice doCreate(Notice vo) throws Exception;

	/**
	 * description：批量创建消息
	 * author：linchunpeng
	 * date：2025/6/30
	 */
	List<Notice> doCreateList(List<Notice> voList);

	/**
	 * 工作事项详情(更新阅读状态)
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public Notice findNoticeById(String noticeId,String userId) throws Exception;
	
	
	/**
	 * 工作事项列表
	 * @param readStatus
	 *           阅读状态
	 * @param user
	 *           用户
	 * @return
	 * @throws Exception
	 */
	public DataPackage<Notice> queryNoticeByCondition(String summary, Boolean readStatus, Collection<Integer> subjectTypes, int page, int lines, String userId) throws Exception;
	
    /**
     * 设置为已读(多个id用,隔开)
     * 
     * @param summary
     * @param readStatus
     * @param creatDate
     * @param page
     * @param lines
     * @param user
     * @return
     * @throws Exception
     */
    public void setNotice2Read(String noticesId) throws Exception;

    /**
     * 将某接收人的所有未读通知标记为已读
     * 
     * @param receiverId
     *            接收人ID
     * @return
     * @throws Exception
     */
    public void markAllAsRead(String receiverId) throws Exception;




	/**
	 * 根据文档id删除通知
	 * @param docId
	 * 		文档id
	 * @throws Exception
	 */
	public void removeByDocId(String docId, String userId) throws Exception;

	List<Map<String, Object>> queryModuleNoticeByCondition(String summary, Boolean readStatus, String userId) throws Exception;
}
