package cn.myapps.message.notice.model;

import java.util.Date;

import cn.myapps.common.model.AuthtimeValueObject;
import com.fasterxml.jackson.annotation.JsonFormat;

import javax.persistence.*;

/**
 * 工作事项通知、提醒
 * @author Happy
 *
 */
@Entity
@Table(name="mc_notice")
public class Notice extends AuthtimeValueObject {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4836070850643712525L;

	@Id
	private String id;

	/**
	 * 通知摘要
	 */
	@Column(name="SUMMARY")
	private String summary;
	
	/**
	 * 通知内容（JSON格式）
	 */
	@Column(name="CONTENT")
	private String content;
	
	/**
	 * @return the content
	 */
	public String getContent() {
		return content;
	}

	/**
	 * @param content the content to set
	 */
	public void setContent(String content) {
		this.content = content;
	}

	/**
	 * 接收用户id
	 */
	@Column(name="TO_USER_ID")
	private String toUserId;
	
	/**
	 * 创建时间
	 */
	@Column(name="CREATE_TIME")
	private Date createTime; 
	
	/**
	 * 是否已读
	 */
	@Column(name="IS_READ")
	private boolean read;
	
	/**
	 * 通知来源（功能模块）
	 */
	@Column(name="MODULE")
	private String module;

	/**
	 * 工作事项链接参数（JSON格式）
	 */
	@Column(name="LINK_PARAMS")
	private String linkParams;
	
	/**
	 * 类型
	 */
	@Column(name="SUBJECT_TYPE")
	private int subjectType;

	@Column(name="DOMAIN_ID")
	private String domainid;

	@Transient
	protected boolean isLazyLoad = true;

	public int getSubjectType() {
		return subjectType;
	}

	public void setSubjectType(int subjectType) {
		this.subjectType = subjectType;
	}

	public String getSummary() {
		return summary;
	}

	public void setSummary(String summary) {
		this.summary = summary;
	}


	public String getToUserId() {
		return toUserId;
	}

	public void setToUserId(String toUserId) {
		this.toUserId = toUserId;
	}

	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}


	public boolean isRead() {
		return read;
	}

	public void setRead(boolean read) {
		this.read = read;
	}

	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}

	public String getLinkParams() {
		return linkParams;
	}

	public void setLinkParams(String linkParams) {
		this.linkParams = linkParams;
	}


	public String getId() {
		return id;
	}


	public void setId(String id) {
		this.id = id;
	}


	public String getDomainid() {
		return domainid;
	}

	public void setDomainid(String domainid) {
		this.domainid = domainid;
	}

	public boolean isLazyLoad() {
		return isLazyLoad;
	}

	public void setLazyLoad(boolean lazyLoad) {
		isLazyLoad = lazyLoad;
	}
}
