package cn.myapps.message.notice.dao;

import cn.myapps.message.notice.model.Notice;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
public interface NoticeDAO extends JpaRepository<Notice,String>, JpaSpecificationExecutor<Notice> {

	/**
	 * 设置事项消息为已读
	 * 
	 * @param noticeId
	 */
	@Transactional
	@Modifying(clearAutomatically = true)
	@Query(value = "update mc_notice mc set mc.IS_READ = 1 where mc.id = ?1",nativeQuery = true)
	public void setNotice2Read(String noticeId) throws Exception;

	/**
	 * 设置事项消息为已读
	 * 
	 * @param receiverId 接受人的ID
	 */
    @Transactional
    @Modifying(clearAutomatically = true)
    @Query(value = "update mc_notice mc set mc.IS_READ = 1 where mc.TO_USER_ID = ?1",nativeQuery = true)
	public Integer markAllAsRead(String receiverId) throws Exception;
}
