package cn.myapps.message.message.service;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.DepartmentAPI;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.UserAPI;
import cn.myapps.message.message.dao.MessageDAO;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.notification.service.NotificationProcess;
import cn.myapps.message.util.sequence.Sequence;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.math.BigInteger;
import java.sql.Connection;
import java.util.*;


@Service
public class MessageProcessBean implements MessageProcess {


    @Autowired
    private MessageDAO messageDAO;

    @Autowired(required=false)
    private NotificationProcess notificationProcess;


    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Message doSaveMessage(ParamsTable params, Message vo, IUser user) throws Exception {
        return null;
    }

    @Override
    public Message doPublicMessage(ParamsTable params, Message vo, IUser user) throws Exception {
        Message message = vo;
        try{
            String applicationId = params.getParameterAsString("application");
            String domainId = user.getDomainid();
            String info = params.getParameterAsString("receiverInfo") ;
            HashSet<String> receiverId = null ;
            HashSet<String> receiverDeptId = null ;
            if(vo != null){
//                beginTransaction();
                //发送者信息
                if(StringUtil.isBlank(vo.getId())){
                    vo.setId(Sequence.getSequence());
                }
                vo.setCreateTime(new Date());
                vo.setSender(user.getName());
                vo.setSenderId(user.getId());
                String defaultDepartmentId = user.getDefaultDepartment();
//                DepartmentProcess dp = (DepartmentProcess) ProcessFactory.createProcess(DepartmentProcess.class);
//                DepartmentVO dept = (DepartmentVO) dp.doView(defaultDepartmentId);
                JSONObject department = getDepartmentById(defaultDepartmentId);
//                vo.setSenderDept(dept.getName());
//                vo.setSenderDeptId(dept.getId());
                vo.setSenderDept((String) department.get("name"));
                vo.setSenderDeptId((String) department.get("id"));
                vo.setComment(true);
                vo.setSticky(false);
                vo.setReceiverInfo(info);
                vo.setDomainid(domainId);

                //发送范围
                if(vo.getScope() == Message.SCOPE_ALL){

                }else if(vo.getScope() == Message.SCOPE_CUSTOM){
                    JSONObject receiverInfo = JSONObject.fromObject(info);
                    JSONArray users = receiverInfo.getJSONArray("user");
                    JSONArray depts = receiverInfo.getJSONArray("dept");

                    if(!users.isEmpty()){
                        if(receiverId == null ){
                            receiverId = new HashSet<String>();
                            receiverDeptId = new HashSet<String>();
                        }
//                        if(us == null){
//                            us = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
//                        }
                        for(int index = 0 ; index < users.size() ; index ++){
                            JSONObject Juser = users.getJSONObject(index);
                            String userId = Juser.getString("userId");
                            String deptId = Juser.getString("deptId");
                            if(!StringUtil.isBlank(userId)){
                                if(!receiverId.contains(userId)){
                                    receiverId.add(userId);
                                    receiverDeptId.add(deptId);
                                }
                            }

                        }
                    }

                    if(!depts.isEmpty()){
                        if(receiverId == null ){
                            receiverId = new HashSet<String>();
                            receiverDeptId = new HashSet<String>();
                        }
//                        if(us == null){
//                            us = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
//                        }

                        //根节点
//                        DepartmentProcess deptProcess = (DepartmentProcess) ProcessFactory.createProcess(DepartmentProcess.class);
//                        DepartmentVO root = deptProcess.getRootDepartmentByDomainId(user.getDomainid());
                        JSONObject rootDepartment = getRootDepartment();
                        for(int index = 0 ; index < depts.size() ; index ++){
                            JSONObject Jdept = depts.getJSONObject(index);
                            String deptId = Jdept.getString("deptId");
                            String rootid = (String) rootDepartment.get("id");
                            if(!rootid.equals(deptId)){ //非根目录
//                                Collection<UserVO> userList = us.queryByDepartment(deptId);
                                JSONArray array = getUsersByDepartment(deptId);
//                                if(!userList.isEmpty()){
//                                    for(UserVO userVO : userList){
//                                        if(!receiverId.contains(userVO.getId())){
//                                            receiverId.add(userVO.getId());
//                                            receiverDeptId.add(deptId);
//                                        }
//                                    }
//                                }
                                if(!array.isEmpty()){
                                    for(Object obj : array){
                                        JSONObject json = JSONObject.fromObject(obj);
                                        String id = (String) json.get("id");
                                        if(!receiverId.contains(id)){
                                            receiverId.add(id);
                                            receiverDeptId.add(deptId);
                                        }
                                    }
                                }
                            }else{
//                                Collection<UserVO> userList = us.queryByDomain(user.getDomainid());
                                receiverId.clear();
                                receiverDeptId.clear();
                                message.setScope(Message.SCOPE_ALL);
                                break;
                            }
                        }
                    }

                    String _receiverId = null ;
                    String _receiverDeptId = null;

                    if(!receiverId.isEmpty()){
                        _receiverId = receiverId.toString().substring(1, receiverId.toString().length()-1);
                        _receiverDeptId = receiverDeptId.toString().substring(1, receiverDeptId.toString().length()-1);
                    }else{
                        _receiverId = "";
                        _receiverDeptId = "";
                    }
                    vo.setReceiverId(_receiverId);
                    vo.setReceiverDeptId(_receiverDeptId);

                }else if(vo.getScope() == Message.SCOPE_MYSELF){

                }
                //生成消息对象
                message = messageDAO.save(vo);
                createNotification4PersonalMessage(message,domainId,user);

			/*    try {
					//TODO
			    	//生成通知消息
					NotificationProcess notificationProcess = new NotificationProcessBean();
					notificationProcess.doCreateMessagesNotification(message,domainId,user);
				} catch (Exception e) {
					e.printStackTrace();
				}*/
//                commitTransaction();
            }
        } catch (Exception e) {
//            rollbackTransaction();
            e.printStackTrace();
            throw e;
        }
        return message ;
    }

    @Override
    public Message doPublicAnnouncement(ParamsTable params, Message vo, IUser user) throws Exception {
        Message message = vo;
        try{
            String applicationId = params.getParameterAsString("application");
            String domainId = user.getDomainid();
//            UserProcess us =  null ;
            Set<String> receiverId = null ;
            Set<String> receiverDeptId = null ;

            if(vo != null){
//                beginTransaction();
                //发送者信息
                if(StringUtil.isBlank(vo.getId())){
                    vo.setId(Sequence.getSequence());
                }
                vo.setCreateTime(new Date());
                vo.setSender(user.getName());
                vo.setSenderId(user.getId());
                String defaultDepartmentId = user.getDefaultDepartment();
                JSONObject department = getDepartmentById(defaultDepartmentId);
                vo.setSenderDept((String) department.get("name"));
                vo.setSenderDeptId((String) department.get("id"));
                vo.setDomainid(domainId);
                //发送范围
                if(vo.getScope()  ==  Message.SCOPE_ALL){

                }else if(vo.getScope() == Message.SCOPE_CUSTOM){
                    String info = params.getParameterAsString("receiverInfo") ;
                    JSONObject receiverInfo = JSONObject.fromObject(info);
                    JSONArray users = receiverInfo.getJSONArray("user");
                    JSONArray depts = receiverInfo.getJSONArray("dept");

                    if(!users.isEmpty()){
                        if(receiverId == null ){
                            receiverId = new HashSet<String>();
                            receiverDeptId = new HashSet<String>();
                        }
                        for(int index = 0 ; index < users.size() ; index ++){
                            JSONObject Juser = users.getJSONObject(index);
                            String userId = Juser.getString("userId");
                            String deptId = Juser.getString("deptId");
                            if(!StringUtil.isBlank(userId)){
                                if(!receiverId.contains(userId)){
                                    receiverId.add(userId);
                                    receiverDeptId.add(deptId);
                                }
                            }

                        }
                    }

                    if(!depts.isEmpty()){
                        if(receiverId == null ){
                            receiverId = new HashSet<String>();
                            receiverDeptId = new HashSet<String>();
                        }
                        JSONObject rootDepartment = getRootDepartment();
                        for(int index = 0 ; index < depts.size() ; index ++){
                            JSONObject Jdept = depts.getJSONObject(index);
                            String deptId = Jdept.getString("deptId");
                            String rootid = (String) rootDepartment.get("id");
                            if(!rootid.equals(deptId)){ //非根目录
                                JSONArray array = getUsersByDepartment(deptId);
                                if(!array.isEmpty()){
                                    for(Object obj : array){
                                        JSONObject json = JSONObject.fromObject(obj);
                                        String id = (String) json.get("id");
                                        if(!receiverId.contains(id)){
                                            receiverId.add(id);
                                            receiverDeptId.add(deptId);
                                        }
                                    }
                                }
                            }else{
                                receiverId.clear();
                                receiverDeptId.clear();
                                message.setScope(Message.SCOPE_ALL);
                                break;
                            }
                        }
                    }

                    String _receiverId = null ;
                    String _receiverDeptId = null;

                    if(!receiverId.isEmpty()){
                        _receiverId = receiverId.toString().substring(1, receiverId.toString().length()-1);
                        _receiverDeptId = receiverDeptId.toString().substring(1, receiverDeptId.toString().length()-1);
                    }else{
                        _receiverId = "";
                        _receiverDeptId = "";
                    }
                    vo.setReceiverId(_receiverId);
                    vo.setReceiverDeptId(_receiverDeptId);

                }else if(vo.getScope() == Message.SCOPE_MYSELF){

                }
                message = messageDAO.save(vo);
                try {
                    notificationProcess.doCreateMessagesNotification(message,domainId,user);
                } catch (Exception e) {
                }
            }
        } catch (Exception e) {
//            rollbackTransaction();
            throw e;
        }
        return message ;
    }

    @Override
    public DataPackage<Message> queryMessages(String content, int page, int lines, IUser user) throws Exception {
        entityManager.clear();
        DataPackage<Message> data = new DataPackage<>();
        data.setPageNo(page);
        data.setLinesPerPage(lines);
        String condition = "";
        if (!StringUtil.isBlank(content)) {
            condition += " AND (me.CONTENT like '" + content + "%' OR me.SENDER like '" + content + "%' OR me.title like '" + content + "%')";
        }

        String sql = "SELECT * FROM MC_MESSAGE me WHERE ? IN (me.SENDER_ID,me.RECEIVER_ID) "+condition;
        String countSql = "SELECT COUNT(*) FROM (" + sql + ") as xt";

        sql = "select * from (" + sql + ") AS TB ORDER BY CREATE_TIME desc";

        Map<Integer, String> map = new HashMap<>();
        int index = 1;
        map.put(1, user.getId());
        Query query = entityManager.createNativeQuery(sql, Message.class);
        Query countQuery = entityManager.createNativeQuery(countSql);
        for (int key : map.keySet()) {
            query.setParameter(key, map.get(key));
            countQuery.setParameter(key, map.get(key));
        }

        query.setFirstResult((page - 1) * lines);
        query.setMaxResults(lines);

        long total = ((BigInteger) countQuery.getSingleResult()).longValue();
        List<Message> list = query.getResultList();
        data.setRowCount((int) total);
        data.setDatas(list);
        return data;
    }

    @Override
    public DataPackage<Message> queryMessagesISend(String content, int page, int lines, IUser user) throws Exception {
        return null;
    }

    @Override
    public DataPackage<Message> queryMessage4Announcement(String content, int page, int lines, IUser user) throws Exception {
        entityManager.clear();
        DataPackage<Message> data = new DataPackage<>();
        data.setPageNo(page);
        data.setLinesPerPage(lines);

        String sql = "SELECT * FROM MC_MESSAGE me WHERE me.DOMAIN_ID=? AND ? IN (me.SENDER_ID,me.RECEIVER_ID)";
        String countSql = "SELECT COUNT(*) FROM  MC_MESSAGE me WHERE me.DOMAIN_ID=? AND ? IN (me.SENDER_ID,me.RECEIVER_ID)";

        sql += "AND me.TYPE = "+ Message.TYPE_ANNOUNCEMENT;
        countSql += "AND me.TYPE = "+ Message.TYPE_ANNOUNCEMENT;

        if(!StringUtil.isBlank(content)){
            sql += " AND (me.CONTENT like '%"+ content +"%' OR me.SENDER like '%"+ content +"%' OR me.title like '%"+ content +"%')";
            countSql += " AND (me.CONTENT like '%"+ content +"%' OR me.SENDER like '%"+ content +"%' OR me.title like '%"+ content +"%')";
        }

        sql =  "select * from (" +sql+ ") AS TB ORDER BY IS_STICKY desc,CREATE_TIME desc";

        Map<Integer,String> map = new HashMap<>();
        int index = 1;
        map.put(1, user.getDomainid());
        map.put(2, user.getId());

        Query query = entityManager.createNativeQuery(sql,Message.class);
        Query countQuery = entityManager.createNativeQuery(countSql);
        for (int key : map.keySet()) {
            query.setParameter(key, map.get(key));
            countQuery.setParameter(key, map.get(key));
        }

        query.setFirstResult((page-1)*lines);
        query.setMaxResults(lines);

        long total = ((BigInteger)countQuery.getSingleResult()).longValue();
        List<Message> list = query.getResultList();
        data.setRowCount((int) total);
        data.setDatas(list);
        return data;
    }

    @Override
    public DataPackage<Message> queryMessage4Department(String content, Integer page, Integer lines, IUser user) throws Exception {
        return null;
    }

    @Override
    public void doDeleteMessageAndNotification(String messageId, String applicationId) throws Exception {
        try {
//            beginTransaction();
//            ((MessageDAO)getDAO()).remove(messageId);
            messageDAO.deleteById(messageId);
            try {
                //TODO
                //删除消息提醒
//                NotificationProcess notificationProcess = new NotificationProcessBean();
                notificationProcess.doRemove(messageId);
            } catch (Exception e) {
                e.printStackTrace();
            }
//            commitTransaction();
        } catch (Exception e) {
//            rollbackTransaction();
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void doCancelMessageTop(String messageId, IUser user) throws Exception {

    }

    @Override
    public void doCreateMessage(String receiverid, String title, String content, String userId) throws Exception {
        Message message = new Message();
        try{
            WebUser user = getUserById(userId);
//            beginTransaction();
            //发送者信息
            setBasicProperties4PersonMessage(message,content,title,user);
            //发送范围
            message.setReceiverId(receiverid);
            //生成消息对象
            message = messageDAO.save(message);
            createNotification4PersonalMessage(message,user.getDomainid(),user);
//            commitTransaction();
        } catch (Exception e) {
//            rollbackTransaction();
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void doCreateMessageByDept(String departmentid, String title, String content, String userId) throws Exception {
//        Message message = new Message();
//        try{
////            UserProcess us = (UserProcess) ProcessFactory.createProcess(UserProcess.class);
////            UserVO user = (UserVO) us.doView(userId);
//            WebUser user = getUserById(userId);
//            HashSet<String> receiverId =  new HashSet<String>();
//            HashSet<String> receiverDeptId =  new HashSet<String>();
////            beginTransaction();
//            //发送者信息
//            setBasicProperties4PersonMessage(message,content,title,user);
//
//
//           // Collection<UserVO> _users = us.queryByDepartment(departmentid);
//            JSONArray array = getUsersByDepartment(departmentid);
//            //添加部门
//            receiverDeptId.add(departmentid);
//            //添加用户
//            for(Object obj : array){
//                JSONObject json = JSONObject.fromObject(obj);
//                String id = (String) json.get("id");
//                if(!receiverId.contains(id)){
//                    receiverId.add(id);
//                }
//            }
//
//            String _receiverId = "";
//            String _receiverDeptId = "";
//
//            if(!receiverId.isEmpty()){
//                _receiverId = receiverId.toString().substring(1, receiverId.toString().length()-1);
//                _receiverDeptId = receiverDeptId.toString().substring(1, receiverDeptId.toString().length()-1);
//            }else{
//                _receiverId = "";
//                _receiverDeptId = "";
//            }
//
//            message.setReceiverId(_receiverId);
//            message.setReceiverDeptId(_receiverDeptId);
//
//            //生成消息对象
//            message = messageDAO.save(message);
//
//            createNotification4PersonalMessage(message,user.getDomainid(),user);
////            commitTransaction();
//        } catch (Exception e) {
////            rollbackTransaction();
//            e.printStackTrace();
//            throw e;
//        }
    }

    @Override
    public void doCreateMessageByRole(String roleid, String title, String content, String userId) throws Exception {
//        Message message = new Message();
//        try{
//            WebUser user = getUserById(userId);
//            HashSet<String> receiverId =  new HashSet<String>();
//            setBasicProperties4PersonMessage(message,content,title,user);
//            JSONArray array = getUsersByRole(roleid);
//            //添加用户
//            for(Object obj : array){
//                JSONObject json = JSONObject.fromObject(obj);
//                String id = (String) json.get("id");
//                if(!receiverId.contains(id)){
//                    receiverId.add(id);
//                }
//            }
//            String _receiverId = "";
//            if(!receiverId.isEmpty()){
//                _receiverId = receiverId.toString().substring(1, receiverId.toString().length()-1);
//            }else{
//                _receiverId = "";
//            }
//            message.setReceiverId(_receiverId);
//            //生成消息对象
//            message = messageDAO.save(message);
//            createNotification4PersonalMessage(message,user.getDomainid(),user);
////            commitTransaction();
//        } catch (Exception e) {
////            rollbackTransaction();
//            e.printStackTrace();
//            throw e;
//        }
    }

    @Override
    public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public Message doView(String pk) throws Exception {
        return messageDAO.findById(pk).get();
    }

    @Override
    public void doRemove(String pk) throws Exception {

    }

    @Override
    public void doRemove(String[] pk) throws Exception {

    }

    @Override
    public DataPackage<Message> doQuery(ParamsTable params, IUser user) throws Exception {
        return null;
    }

    private JSONObject getDepartmentById(String departmentId){
//        UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        UserAPI departmentAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        Resource departmentUsers = departmentAPI.getAllDepartmentUsers();
        JSONArray array = JSONArray.fromObject(departmentUsers.getData());
        for(Object obj:array){
            JSONObject json = JSONObject.fromObject(obj);
            if(departmentId.equals(json.get("id"))){
                return json;
            }
        }
        return new JSONObject();
    }

    private JSONObject getRootDepartment(){
//        UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        UserAPI departmentAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        Resource departmentUsers = departmentAPI.getAllDepartmentUsers();
        JSONArray array = JSONArray.fromObject(departmentUsers.getData());
        for(Object obj:array){
            JSONObject json = JSONObject.fromObject(obj);
            int level = (int) json.get("level");
            if(0==level){
                return json;
            }
        }
        return new JSONObject();
    }

    private JSONArray getUsersByDepartment(String deptid){
        UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        Collection departmentUsers = userAPI.getDepartmentUsers(deptid);
        JSONArray array = JSONArray.fromObject(departmentUsers);
        return array;
    }


    private JSONArray getUsersByDomian(String domainid){
        UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        Collection departmentUsers = userAPI.getDomainUsers(domainid);
        JSONArray array = JSONArray.fromObject(departmentUsers);
        return array;
    }

    private WebUser getUserById(String userId) throws Exception {
        WebUser user = new WebUser();
        UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
        Map<String,Object> userMap = new LinkedHashMap<>();
        FeignConfig.ACCESS_TOKEN = Security.getToken(userId);
        userMap= (Map<String, Object>) userAPI.getUserById(userId).getData();
        user.setId(userId);
        user.setName((String) userMap.get("name"));
        user.setDomainid((String) userMap.get("domainId"));
        user.setDefaultDepartment((String) userMap.get("deptId"));
        return user;
    }

    private void createNotification4PersonalMessage(Message message,String domainId,IUser user){
        try {
            // TODO
            // 生成通知消息
//            NotificationProcess notificationProcess = new NotificationProcessBean();
            notificationProcess.doCreateNotification4PerssonalMessage(message,domainId,user);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * 设置消息主体的基本信息
     * @param msg
     * @param isComment
     * @param isSticky
     * @param user
     * @throws Exception
     */
    private void setBasicProperties4PersonMessage(Message msg , String content, String title, IUser user) throws Exception{
        //发送者信息
        if(StringUtil.isBlank(msg.getId())){
            msg.setId(Sequence.getSequence());
        }
        String defaultDepartmentId = user.getDefaultDepartment();
//      DepartmentProcess dp = (DepartmentProcess) ProcessFactory.createProcess(DepartmentProcess.class);
        msg.setCreateTime(new Date());
        msg.setSender(user.getName());
        msg.setSenderId(user.getId());

        JSONObject department = getDepartmentById(defaultDepartmentId);
//        DepartmentVO dept = (DepartmentVO) dp.doView(defaultDepartmentId);
//        msg.setSenderDept(dept.getName());
//        msg.setSenderDeptId(dept.getId());
        msg.setSenderDept((String) department.get("name"));
        msg.setSenderDeptId((String) department.get("id"));
        msg.setDomainid(user.getDomainid());
        msg.setComment(true);
        msg.setSticky(false);
        msg.setTitle(title);
        msg.setContent(content);
        msg.setType(Message.TYPE_STANDARD);
        msg.setScope(Message.SCOPE_CUSTOM);
    }
}
