package cn.myapps.message.message.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.message.model.Message;
import org.springframework.stereotype.Service;

@Service
public interface MessageProcess extends BaseProcess<Message> {

	public Message doView(String pk) throws Exception;
	/**
	 * 消息保存
	 * 
	 * @param vo
	 * @param user
	 * @return
	 */
	public Message doSaveMessage(ParamsTable params, Message vo, IUser user) throws Exception;

	/**
	 * 消息发布
	 * 
	 * @param vo
	 * @param user
	 * @return
	 */
	public Message doPublicMessage(ParamsTable params, Message vo, IUser user) throws Exception;

	/**
	 * 公告发布
	 * 
	 * @param vo
	 * @param user
	 * @return
	 */
	public Message doPublicAnnouncement(ParamsTable params, Message vo, IUser user) throws Exception;

	/**
	 * 信息中心
	 * 
	 * @param title
	 * @param scope
	 * @param type
	 * @param createTime
	 * @param sender
	 * @param page
	 * @param lines
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public DataPackage<Message> queryMessages(String content, int page, int lines, IUser user) throws Exception;

	/**
	 * 我发出的信息
	 * 
	 * @param title
	 * @param scope
	 * @param type
	 * @param createTime
	 * @param page
	 * @param lines
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public DataPackage<Message> queryMessagesISend(String content, int page, int lines, IUser user) throws Exception;

	/**
	 * 公告信息
	 * 
	 * @param title
	 * @param scope
	 * @param type
	 * @param createTime
	 * @param page
	 * @param lines
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public DataPackage<Message> queryMessage4Announcement(String content, int page, int lines, IUser user)
			throws Exception;

	/**
	 * 
	 * 部门消息
	 * 
	 * @param title
	 * @param content
	 * @param scope
	 * @param object
	 * @param page
	 * @param lines
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public DataPackage<Message> queryMessage4Department(String content, Integer page, Integer lines, IUser user)
			throws Exception;

	/**
	 * 删除消息
	 * 
	 * @param messageId
	 * @param applicationId
	 * @throws Exception
	 */
	public void doDeleteMessageAndNotification(String messageId, String applicationId) throws Exception;

	/**
	 * 取消置顶(如果messageId为空，则取消所有置顶)
	 * 
	 * @param messageId
	 * @param applicationId
	 * @throws Exception
	 */
	public void doCancelMessageTop(String messageId, IUser user) throws Exception;

	/**
	 * 发送站内短信
	 * 
	 * @param senderid
	 * @param receiverid
	 * @param title
	 * @param content
	 * @throws Exception
	 */
	public void doCreateMessage(String receiverid, String title, String content, String userId) throws Exception;

	/**
	 * 根据部门发送站内短信
	 * 
	 * @param senderid
	 * @param receiverid
	 * @param title
	 * @param content
	 * @throws Exception
	 */
	public void doCreateMessageByDept(String departmentid, String title, String content, String userId)
			throws Exception;

	/**
	 * 根据角色发送站内短信
	 * 
	 * @param senderid
	 * @param receiverid
	 * @param title
	 * @param content
	 * @throws Exception
	 */
	public void doCreateMessageByRole(String roleid, String title, String content, String userId) throws Exception;

}
