package cn.myapps.message.message.model;

import java.util.Date;

import org.codehaus.jackson.map.annotate.JsonSerialize;

import com.fasterxml.jackson.annotation.JsonFormat;

import cn.myapps.common.model.AuthtimeValueObject;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 消息
 * @author Happy
 *
 */
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@Entity
@Table(name="mc_message")
public class Message extends AuthtimeValueObject {

	/**
	 *
	 */
	private static final long serialVersionUID = -5393658673544469998L;

	/**
	 * 消息类型-常规消息
	 */
	public static final int TYPE_STANDARD = 0;
	/**
	 * 消息类型-通知公告消息
	 */
	public static final int TYPE_ANNOUNCEMENT = 1;
	/**
	 * 消息类型-工作事项提醒消息
	 */
	public static final int TYPE_WORK_REMIND = 2;

	/**
	 * 可见范围-全公司可见
	 */
	public static final int SCOPE_ALL = 0;

	/**
	 * 可见范围-仅自己可见
	 */
	public static final int SCOPE_MYSELF = 1;

	/**
	 * 可见范围-自定义可见范围
	 */
	public static final int SCOPE_CUSTOM = 2;

	public static final String MODULE_MESSAGE = "message";
	public static final String MODULE_PM = "pm";
	public static final String MODULE_KM = "km";
	public static final String MODULE_QM = "qm";

	@Id
	private String id;

	/**
	 * 标题
	 */
	@Column(name = "TITLE")
	private String title;

	/**
	 * 内容
	 */
	@Column(name = "CONTENT")
	private String content;

	/**
	 * 附件（json格式）
	 */
	@Column(name = "ATTACHMENT")
	private String attachment;

	/**
	 * 发表时间
	 */
	@Column(name = "CREATE_TIME")
	private Date createTime;

	/**
	 * 发送者名称
	 */
	@Column(name = "SENDER")
	private String sender;

	/**
	 * 发送者id
	 */
	@Column(name = "SENDER_ID")
	private String senderId;

	/**
	 * 发送者默认部门名称
	 */
	@Column(name = "SENDER_DEPT")
	private String senderDept;

	/**
	 * 发送者默认部门id
	 */
	@Column(name = "SENDER_DEPT_ID")
	private String senderDeptId;

	/**
	 * 发送范围（消息可见范围）
	 */
	@Column(name = "SCOPE")
	private int scope;

	/**
	 * 接收者信息(JSON)
	 * <p>
	 * {user: [{ userId: userName: }],dept: [{ deptId: deptName: }]}
	 */
	@Column(name = "RECEIVER_INFO")
	private String receiverInfo;

	/**
	 * 接收者id（多个接收者用‘;’隔离）
	 */
	@Column(name = "RECEIVER_ID")
	private String receiverId;

	/**
	 * 接收者所属部门id（多个接收者部门用‘;’隔离）
	 */
	@Column(name = "RECEIVER_DEPT_ID")
	private String receiverDeptId;

	/**
	 * 评论总数
	 */
	@Column(name = "COMMENT_COUNT")
	private int commentCount;

	/**
	 * 消息类型
	 */
	@Column(name = "TYPE")
	private int type;

	/**
	 * 消息分类
	 */
	@Column(name = "CATEGORY")
	private String category;

	/**
	 * 置顶
	 */
	@Column(name = "IS_STICKY")
	private boolean sticky;

	/**
	 * 是否评论
	 */
	@Column(name = "IS_COMMENT")
	private boolean comment;

	/**
	 * 消息来源、所属模块
	 */
	@Column(name = "MODULE")
	private String module;

	@Column(name = "DOMAIN_ID")
	private String domainid;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getAttachment() {
		return attachment;
	}

	public void setAttachment(String attachment) {
		this.attachment = attachment;
	}

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String senderId) {
		this.senderId = senderId;
	}

	public String getSenderDept() {
		return senderDept;
	}

	public void setSenderDept(String senderDept) {
		this.senderDept = senderDept;
	}

	public String getSenderDeptId() {
		return senderDeptId;
	}

	public void setSenderDeptId(String senderDeptId) {
		this.senderDeptId = senderDeptId;
	}

	public int getScope() {
		return scope;
	}

	public void setScope(Integer scope) {
		if(scope!=null) {
			this.scope = scope;
		}
	}

	public String getReceiverId() {
		return receiverId;
	}

	public void setReceiverId(String receiverId) {
		this.receiverId = receiverId;
	}

	public String getReceiverDeptId() {
		return receiverDeptId;
	}

	public void setReceiverDeptId(String receiverDeptId) {
		this.receiverDeptId = receiverDeptId;
	}

	public int getCommentCount() {
		return commentCount;
	}

	public void setCommentCount(int commentCount) {
		this.commentCount = commentCount;
	}

	public int getType() {
		return type;
	}

	public void setType(Integer type) {
		if(type!=null) {
			this.type = type;
		}
	}

	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}

	public String getReceiverInfo() {
		return receiverInfo;
	}

	public void setReceiverInfo(String receiverInfo) {
		this.receiverInfo = receiverInfo;
	}

	public boolean isSticky() {
		return sticky;
	}

	public void setSticky(Boolean sticky) {
		if(sticky!=null) {
			this.sticky = sticky;
		}
	}

	public boolean isComment() {
		return comment;
	}

	public void setComment(boolean comment) {
		this.comment = comment;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getDomainid() {
		return domainid;
	}

	@Override
	public void setDomainid(String domainid) {
		this.domainid = domainid;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getCategory() {
		return category;
	}
}
