package cn.myapps.message.message.dao;

import cn.myapps.base.web.WebUser;
import cn.myapps.message.message.model.Message;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Repository
public interface MessageDAO extends JpaRepository<Message,String>, JpaSpecificationExecutor<Message> {
//	/**
//	 * 根据条件获取消息(消息列表)
//	 * @param content
//	 * @param page
//	 * @param lines
//	 * @param user
//	 * @return
//	 */
//	public DataPackage<Message> queryMessages(String content,int page, int lines, IUser user) throws Exception;
//
//	/**
//	 * 获取我发送的消息
//	 * @param content
//	 * @param page
//	 * @param lines
//	 * @param user
//	 * @return
//	 * @throws Exception
//	 */
//	public DataPackage<Message> queryMessagesISend(String content,int page, int lines, IUser user)throws Exception;
//
//	/**
//	 * 获取公告消息
//	 * @param content
//	 * @param page
//	 * @param lines
//	 * @param user
//	 * @return
//	 * @throws Exception
//	 */
//	public DataPackage<Message> queryMessage4Announcement(String content, int page,
//			int lines, IUser user)throws Exception;
//
//	/**
//	 * 取消置顶(如果messageId为空，则取消所有置顶)
//	 * @param messageId
//	 * @param user
//	 */
//	public void cancelMessageTop(String messageId, IUser user)throws Exception;
//
//	/**
//	 * 获取部门消息
//	 * @param content
//	 * @param page
//	 * @param lines
//	 * @param user
//	 * @return
//	 * @throws Exception
//	 */
//	public DataPackage<Message> queryMessage4Department(String content, Integer page,Integer lines, IUser user)throws Exception;
    @Modifying
    @Transactional
    @Query("UPDATE Message ME SET ME.sticky=0,ME.domainid=?1 WHERE ME.id=?2")
    public void cancelMessageTop(String domainid,String messageId)throws Exception;


    @Modifying
    @Transactional
    @Query("UPDATE Message ME SET ME.sticky=0,ME.domainid=?1")
    public void cancelMessageTopByDomainid(String domainid)throws Exception;

    @Modifying
    @Transactional
    @Query(nativeQuery = true,value = "UPDATE MC_MESSAGE SET COMMENT_COUNT = (SELECT COUNT(*) FROM MC_comment WHERE MESSAGE_ID =?1)")
    public void Updatecomment_count(String messageId)throws Exception;
}
