package cn.myapps.message.message.controller;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import cn.myapps.common.controller.Resource;
import cn.myapps.common.util.*;
import cn.myapps.conf.DepartmentAPI;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.UserAPI;
import cn.myapps.message.message.service.MessageProcessBean;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import net.sf.json.JSONArray;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.message.base.controller.BaseController;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.comment.service.CommentProcess;
import cn.myapps.message.comment.service.CommentProcessBean;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.message.service.MessageProcess;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONObject;

@Controller(value="MessageAction")
@RequestMapping(value="/api/message/messages")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@Api(tags = "消息模块")
public class MessageController extends BaseController<Message>{

	@Autowired
	private CommentProcess commentProcess;


	@Autowired
	private MessageProcess messageProcess;

	@Autowired
	private DistributedCacheProvider distributedCacheProvider;


	public MessageController() {
		super();
		content = new Message();
		process = new MessageProcessBean();
	}


	/**
	 * 获取消息以及评论内容
	 * @return
	 */
	@GetMapping
	@ApiOperation(value = "获取消息以及评论内容", notes = "获取消息以及评论内容")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "messageId",value = "消息id",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doGetMessage(){
		try {
			IUser user = getUser();
			ParamsTable params = getParams();
			String messageId = params.getParameterAsString("messageId");
			Message message = messageProcess.doView(messageId);
			CommentProcess cp = new CommentProcessBean();
			DataPackage<Comment> comments = commentProcess.queryComments4Message(messageId, 1, 100, user);
			JSONObject result = new JSONObject();
			result.put("message", message);
			result.put("comments",comments );
			return addActionResult(true, "", result);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 发布消息
	 * @return
	 */
	@PostMapping
	@ApiOperation(value = "发布消息", notes = "发布消息")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
	})
	public Map<String, Object> doPublicMessage(){
		try {
			IUser user = getUser();
			Message message = (Message) getContent();
			ParamsTable params = getParams();
			message.setContent(params.getParameterAsString("content.content"));
			message.setAttachment(params.getParameterAsString("content.attachment"));
			message.setScope(params.getParameterAsInteger("content.scope"));
			message.setType(params.getParameterAsInteger("content.type"));

			message = messageProcess.doPublicMessage(params,message, user);
			return addActionResult(true, "发布成功", message);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 发布公告
	 * @return
	 */
	@PostMapping(value="/announcement")
	@ApiOperation(value = "发布公告", notes = "发布公告")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
	})
	public Map<String, Object> doPublicAnnouncement(){
		try {
			IUser user = getUser();
			Message message = (Message) getContent();
			ParamsTable params = getParams();
			message.setTitle(params.getParameterAsString("content.title"));
			message.setCategory(params.getParameterAsString("content.category"));
			message.setContent(params.getParameterAsString("content.content"));
			message.setScope(params.getParameterAsInteger("content.scope"));
			message.setType(params.getParameterAsInteger("content.type"));
			message.setSticky(Boolean.valueOf(params.getParameterAsString("content.sticky")));
			message = messageProcess.doPublicAnnouncement(params,message, user);
			return addActionResult(true, "发布成功", message);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}


	/**
	 * 创建站内消息
	 * @return
	 */
	@PostMapping(value="/create")
	@ApiOperation(value = "发布公告", notes = "发布公告")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "receiverids",value = "接收人",required = true,paramType = "body",dataType = "string"),
			@ApiImplicitParam(name = "title", value = "标题", required = false, paramType = "query", dataType = "string"),
			@ApiImplicitParam(name = "content", value = "内容", required = false, paramType = "query", dataType = "string"),
			@ApiImplicitParam(name = "userId", value = "发送用户", required = false, paramType = "query", dataType = "string")
	})
	public void doCreateMessage( String receiverids,  String title,
								 String content,  String userId) throws Exception{
		if(StringUtils.isEmpty(FeignConfig.ACCESS_TOKEN)){
			FeignConfig.ACCESS_TOKEN = Security.getToken(userId);
		}
		messageProcess.doCreateMessage(receiverids,title,content,userId);
	}


	/**
	 * 删除信息
	 * @return
	 */
	@DeleteMapping
	@ApiOperation(value = "删除信息", notes = "删除信息")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "applicationId",value = "应用id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "messageId",value = "消息id",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doDelete(@RequestParam String messageId){
		try {
			ParamsTable params = getParams();
			//String id = params.getParameterAsString("messageId");
			String applicationId = params.getParameterAsString("applicationId");
			messageProcess.doDeleteMessageAndNotification(messageId,applicationId);
			return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 消息列表查询(包含条件) //首页查询
	 * @return
	 */

	@GetMapping(value="/list")
	@ApiOperation(value = "查询消息列表查询(包含条件) ", notes = "查询消息列表查询(包含条件) ")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string"),
			@ApiImplicitParam(name = "_currpage", value = "页长度", required = false, paramType = "query", dataType = "string"),
			@ApiImplicitParam(name = "_rowcount", value = "当前页码", required = false, paramType = "query", dataType = "string")
	})
	public Map<String, Object> doQuery4Message() {
		try {
			ParamsTable params = getParams();
			String content = params.getParameterAsString("content");
			Integer page = params.getParameterAsInteger("_currpage");
			Integer lines = params.getParameterAsInteger("_rowcount");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 30;
			IUser user = getUser();

			Integer finalPage = page;
			Integer finalLines = lines;
			DataPackage<Message> data = null;
			data = messageProcess.queryMessages(content, finalPage, finalLines, user);

			return addActionResult(true, "", data);
		} catch (Exception e) {
			e.printStackTrace();
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 公告型消息列表(包含条件) //公告查询
	 * @return
	 */
	@GetMapping(value="/announcement")
	@ApiOperation(value = "公告型消息列表(包含条件) ", notes = "公告型消息列表(包含条件) ")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string"),
			@ApiImplicitParam(name = "_currpage", value = "页长度", required = false, paramType = "query", dataType = "string"),
			@ApiImplicitParam(name = "_rowcount", value = "当前页码", required = false, paramType = "query", dataType = "string")
	})
	public Map<String, Object> doQuery4Announcement() {
		try {
			ParamsTable params = getParams();
			String content = params.getParameterAsString("content");
			Integer page = params.getParameterAsInteger("_currpage");
			Integer lines = params.getParameterAsInteger("_rowcount");
			if (page == null || page <= 0)
				page = 1;
			if (lines == null || lines <= 0)
				lines = 30;
			IUser user = getUser();
			String cacheKey = String.format("doQuery4Announcement:%s-%s-%s", user.getId(), page, content);
			Integer finalPage = page;
			Integer finalLines = lines;
			DataPackage<Message> data =
					this.distributedCacheProvider.get(cacheKey, () -> {
						try {
							return messageProcess.queryMessage4Announcement(content, finalPage, finalLines, user);
						} catch (Exception e) {
							return null;
						}
					}, 60 * 5);

			return addActionResult(true, "", data);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}

	/**
	 * 查看预览文件，判断是否存在swf和pdf格式的转换文件
	 * @return
	 * @throws Exception
	 */
	@GetMapping(value="/attachement/preview")
	@ApiOperation(value = "查看预览文件", notes = "查看预览文件")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "id",value = "文件id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "extName",value = "后缀名",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "url",value = "文件路径",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doView4Attachement()throws Exception {
		ParamsTable params = getParams();
		String id = params.getParameterAsString("id");
		String extName = params.getParameterAsString("extName");
		String url = params.getParameterAsString("url");
		Map<String,String> info = new HashMap<String,String>();
		try {
			if (!StringUtil.isBlank(url) && !StringUtil.isBlank(extName) && !StringUtil.isBlank(id) ) {
				//服务器目录的绝对路径
//				WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
//		        ServletContext servletContext = webApplicationContext.getServletContext();
//				String realPath = servletContext.getRealPath("");
				String realPath=PropertyUtil.getPath()+"/workspace";
				//原文件的存放路径
				String origPath = realPath + url;
				//swf文件的存放路径
				String swfPath = realPath + url.substring(0, url.indexOf(id))+ "/swf/" + id +".swf";
				File origFile = new File(origPath);
				File swfFile = new File(swfPath);
				if(origFile.exists()){
					info.put("origPath", origPath);
					if(swfFile.exists()){
						info.put("swfPath", swfPath);
						info.put("is2SWF", "true");
					}else{
						try {
							//生成文件转换任务
							String rootPath = PropertyUtil.getPath();
							FileWriteUtil.writeKmConvertTask(rootPath,id,origFile.getPath());
						} catch (Exception e) {
							e.printStackTrace();
						}
						info.put("swfPath", swfPath);
						info.put("is2SWF", "false");
					}
				}else{
					info.put("origPath", "");
					info.put("swfPath", "");
					info.put("is2SWF", "false");
				}
			}else{
				info.put("origPath", "");
				info.put("swfPath", "");
				info.put("is2SWF", "false");
			}
			return addActionResult(true, "", info);
		} catch (Exception e) {
			return addActionResult(false, e.getMessage(), null);
		}
	}
}
