package cn.myapps.message.comment.service;

import java.util.*;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.comment.dao.CommentDAO;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.message.dao.MessageDAO;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notification.dao.NotificationDAO;
import cn.myapps.message.notification.model.Notification;
import cn.myapps.message.notification.service.NotificationProcess;
import cn.myapps.message.notification.service.NotificationProcessBean;
import cn.myapps.message.util.sequence.Sequence;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

@Service
public class CommentProcessBean implements BaseProcess<Comment>, CommentProcess {

	@Autowired
	private CommentDAO commentDAO;

	@Autowired
	private MessageDAO messageDAO;

	@Autowired
	private NotificationDAO notificationDAO;

	@Autowired
	private NotificationProcess notificationProcess;


	@Override
	public Comment doComment(ParamsTable params, Comment vo, IUser user) throws Exception {
		Comment comment = null;
		try {
			String domainId = user.getDomainid();
			String toContent = params.getParameterAsString("toContent");
			if (vo != null) {
//				beginTransaction();
				// 发送者信息
				vo.setId(Sequence.getSequence());
				vo.setDomainid(domainId);
				vo.setCreateTime(new Date());
				vo.setSender(user.getName());
				vo.setSenderId(user.getId());
				vo.setToContent(toContent);
				vo.setRead(false);
				String module = null; // ?
				vo.setModule(module);
				// 生成消息对象
				comment = commentDAO.save(vo);
				messageDAO.Updatecomment_count(vo.getMessageId());


				try {
					// TODO
					// 生成通知消息
//					NotificationProcess notificationProcess = new NotificationProcessBean();
					notificationProcess.doCreateCommentNotification(comment, domainId, user);
				} catch (Exception e) {
					e.printStackTrace();
				}
//				commitTransaction();
			}
		} catch (Exception e) {
//			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
		return comment;
	}

	@Override
	public void doDeleteCommon(String commentId, String messageId, String domainId) throws Exception {
		try {
//			beginTransaction();
//			commentDAO.doRemove(commentId, messageId);
			commentDAO.deleteById(commentId);
			Specification specification = new Specification<Comment>() {
				@Override
				public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (messageId != null && !messageId.equals("")) {
						predicates.add(cb.equal(root.get("messageId"),messageId));
					}
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};
			long count = commentDAO.count(specification);

			Message message = messageDAO.findById(messageId).get();
			message.setCommentCount((int) count);
			messageDAO.save(message);
//			commitTransaction();
		} catch (Exception e) {
//			rollbackTransaction();
			e.printStackTrace();
			throw e;
		}
	}

	@Override
	public DataPackage<Comment> queryComments4Message(String messageId, Integer page, Integer lines, IUser user)
			throws Exception {
		DataPackage<Comment> dp = new DataPackage<Comment>();
		dp.setPageNo(page);
		dp.setLinesPerPage(lines);
		Pageable pageable = PageRequest.of(page-1, lines);
		try {
			Specification specification = new Specification<Comment>() {
				@Override
				public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (messageId != null && !messageId.equals("")) {
						predicates.add(cb.equal(root.get("messageId"),messageId));
					}
					if (user.getDomainid() != null && !user.getDomainid().equals("")) {
						predicates.add(cb.equal(root.get("domainid"),user.getDomainid()));
					}
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};
			long count = commentDAO.count(specification);
			List<Comment> list = commentDAO.findAll(specification,pageable).getContent();
//			datas = commentDAO.queryComments4Message(messageId, page, lines, user);
			// 将获取的数据设置为已读
			dp.setRowCount((int) count);
			dp.setDatas(list);
			setComment2Read(dp, user);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dp;
	}

	@Override
	public DataPackage<Comment> queryCommentIReply(String content, int page, int lines, IUser user) throws Exception {
		DataPackage<Comment> dp = new DataPackage<Comment>();
		dp.setPageNo(page);
		dp.setLinesPerPage(lines);
		Pageable pageable = PageRequest.of(page-1, lines);
		Specification specification = new Specification<Comment>() {
			@Override
			public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
				List<Predicate> predicates = new ArrayList<>();
				if (user.getId() != null && !user.getId().equals("")) {
					predicates.add(cb.equal(root.get("senderId"),user.getId()));
				}
				if (user.getDomainid() != null && !user.getDomainid().equals("")) {
					predicates.add(cb.equal(root.get("domainid"),user.getDomainid()));
				}
				if(!StringUtil.isBlank(content)){
					predicates.add(cb.like(root.get("content"),"%"+content+"%"));
				}
				Predicate[] pre = new Predicate[predicates.size()];
				query.where(predicates.toArray(pre));
				return cb.and(predicates.toArray(pre));
			}
		};
		List<Comment> list= commentDAO.findAll(specification, pageable).getContent();
		dp.setDatas(list);
		long count = commentDAO.count(specification);
		dp.setRowCount((int) count);
		return dp;
	}

	@Override
	public DataPackage<Comment> queryCommentIReceive(String content, int page, int lines, IUser user) throws Exception {
		DataPackage<Comment> dp = new DataPackage<Comment>();
		dp.setPageNo(page);
		dp.setLinesPerPage(lines);
		Pageable pageable = PageRequest.of(page-1, lines);
		try {
			Specification specification = new Specification<Comment>() {
				@Override
				public Predicate toPredicate(Root<Comment> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
					List<Predicate> predicates = new ArrayList<>();
					if (user.getId() != null && !user.getId().equals("")) {
						predicates.add(cb.equal(root.get("toUserId"),user.getId()));
					}
					if (user.getDomainid() != null && !user.getDomainid().equals("")) {
						predicates.add(cb.equal(root.get("domainid"),user.getDomainid()));
					}
					if(!StringUtil.isBlank(content)){
						predicates.add(cb.like(root.get("content"),"%"+content+"%"));
					}
					Predicate[] pre = new Predicate[predicates.size()];
					query.where(predicates.toArray(pre));
					return cb.and(predicates.toArray(pre));
				}
			};
			List<Comment> list= commentDAO.findAll(specification, pageable).getContent();
			dp.setDatas(list);
			long count = commentDAO.count(specification);
			dp.setRowCount((int) count);
			// 将获取的数据设置为已读
			setComment2Read(dp, user);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return dp;
	}

	/**
	 * 设置本人且未读的评论为已读
	 * 
	 * @param datas
	 * @param user
	 * @throws Exception
	 */
	private void setComment2Read(DataPackage<Comment> datas, IUser user) throws Exception {

		try {
			if (!datas.getDatas().isEmpty()) {
//				beginTransaction();
				Collection<Comment> comments = datas.getDatas();
				Collection<Comment> data = new ArrayList();
				for (Comment comment : comments) {
					if (comment.isRead() == false && comment.getToUserId().equals(user.getId())) {
						data.add(comment);
						notificationDAO.deleteAllByMessageId(comment.getId());
					}
				}
//				commentDAO.setComment2Read(data);
				commentDAO.saveAll(data);
//				commitTransaction();
			}
		} catch (Exception e) {
//			rollbackTransaction();
			throw e;
		}
	}

	@Override
	public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
		return null;
	}

	@Override
	public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
		return null;
	}

	@Override
	public AuthtimeValueObject doView(String pk) throws Exception {
		return null;
	}

	@Override
	public void doRemove(String pk) throws Exception {

	}

	@Override
	public void doRemove(String[] pk) throws Exception {

	}

	@Override
	public DataPackage<Comment> doQuery(ParamsTable params, IUser user) throws Exception {
		return null;
	}
}
