package cn.myapps.message.comment.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.comment.model.Comment;

public interface CommentProcess extends BaseProcess<Comment> {

	/**
	 * 回复/评论消息
	 * 
	 * @param vo
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public Comment doComment(ParamsTable params, Comment content, IUser user) throws Exception;

	/**
	 * 我回复的评论
	 * 
	 * @param createDate
	 * @param senderName
	 * @param content
	 * @param title
	 * @param scope
	 * @param type
	 * @param createTime
	 * @param page
	 * @param lines
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public DataPackage<Comment> queryCommentIReply(String content, int page, int lines, IUser user) throws Exception;

	/**
	 * 我收到的评论
	 * 
	 * @param createDate
	 * @param senderName
	 * @param content
	 * @param title
	 * @param scope
	 * @param type
	 * @param createTime
	 * @param page
	 * @param lines
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public DataPackage<Comment> queryCommentIReceive(String content, int page, int lines, IUser user) throws Exception;

	/**
	 * 删除评论
	 * 
	 * @param commentId
	 * @param messageId
	 * @param domainId
	 * @return
	 * @throws Exception
	 */
	public void doDeleteCommon(String commentId, String messageId, String domainId) throws Exception;

	/**
	 * 消息下的评论列表
	 * 
	 * @param messageId
	 * @param page
	 * @param lines
	 * @param user
	 * @return
	 */
	public DataPackage<Comment> queryComments4Message(String messageId, Integer page, Integer lines, IUser user)
			throws Exception;

}
