package cn.myapps.message.comment.model;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonFormat;

import cn.myapps.common.model.AuthtimeValueObject;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 消息评论
 * @author Happy
 *
 */
@Entity
@Table(name="mc_comment")
public class Comment extends AuthtimeValueObject{

	/**
	 * 
	 */
	private static final long serialVersionUID = 4529093435148520622L;

	@Id
	private String id;
	
	/**
	 * 内容
	 */
	@Column(name="CONTENT")
	private String content;
	
	/**
	 * 附件（json格式）
	 */
	@Column(name = "ATTACHMENT")
	private String attachment;
	/**
	 * 发表时间
	 */
	@Column(name = "CREATE_TIME")
	private Date createTime;
	
	/**
	 * 评论者名称
	 */
	@Column(name = "SENDER")
	private String sender;
	
	/**
	 * 评论者id
	 */
	@Column(name = "SENDER_ID")
	private String senderId;
	
	/**
	 * 被评论的消息id
	 */
	@Column(name = "MESSAGE_ID")
	private String messageId;
	
	/**
	 * 被回复的评论的id
	 */
	@Column(name = "COMMENT_ID")
	private String commentId;
	
	/**
	 * 被回复的评论的作者名称
	 */
	@Column(name = "TO_USER")
	private String toUser;
	
	/**
	 * 被回复的评论的作者Id
	 */
	@Column(name = "TO_USER_ID")
	private String toUserId;
	
	/**
	 * 被回复的内容
	 */
	@Column(name = "TO_CONTENT")
	private String toContent;
	
	/**
	 * 所属模块
	 */
	@Column(name = "MODULE")
	private String module;
	
	/**
	 * 是否已读
	 */
	@Column(name = "IS_READ")
	private boolean read;

	@Column(name = "DOMAIN_ID")
	private String domainid;
	
	public boolean isRead() {
		return read;
	}

	public void setRead(boolean read) {
		this.read = read;
	}

	public String getToContent() {
		return toContent;
	}

	public void setToContent(String toContent) {
		this.toContent = toContent;
	}

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public String getAttachment() {
		return attachment;
	}

	public void setAttachment(String attachment) {
		this.attachment = attachment;
	}

	@JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public String getSender() {
		return sender;
	}

	public void setSender(String sender) {
		this.sender = sender;
	}

	public String getSenderId() {
		return senderId;
	}

	public void setSenderId(String senderId) {
		this.senderId = senderId;
	}

	public String getMessageId() {
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	public String getCommentId() {
		return commentId;
	}

	public void setCommentId(String commentId) {
		this.commentId = commentId;
	}

	public String getToUser() {
		return toUser;
	}

	public void setToUser(String toUser) {
		this.toUser = toUser;
	}

	public String getToUserId() {
		return toUserId;
	}

	public void setToUserId(String toUserId) {
		this.toUserId = toUserId;
	}

	public String getModule() {
		return module;
	}

	public void setModule(String module) {
		this.module = module;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@Override
	public String getId() {
		return id;
	}

	@Override
	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getDomainid() {
		return domainid;
	}

	@Override
	public void setDomainid(String domainid) {
		this.domainid = domainid;
	}
}
