package cn.myapps.message.comment.controller;

import java.util.Map;

import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.message.base.controller.BaseController;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.comment.service.CommentProcess;
import cn.myapps.message.comment.service.CommentProcessBean;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
@Controller
@RequestMapping(value="/api/message/comment")
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@Api(tags = "评论模块")
public class CommentController extends BaseController<Comment> {

	@Autowired
	private CommentProcess commentProcess;

	public CommentController() {
		super();
		content = new Comment();
		process = new CommentProcessBean();
	}
	
	/**
	 * 发表评论
	 * @return
	 */
	@PostMapping
	@ApiOperation(value = "发表评论", notes = "发表评论")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
	})
	public Map<String, Object> doComment(){
		try {
			IUser user = getUser();
		    Comment content = (Comment) getContent();
		    ParamsTable params = getParams();
		    content.setToUser(params.getParameterAsString("content.toUser"));
		    content.setToUserId(params.getParameterAsString("content.toUserId"));
		    content.setMessageId(params.getParameterAsString("content.messageId"));
			content.setContent(params.getParameterAsString("content.content"));
		    content = commentProcess.doComment(params,content, user);
		    return addActionResult(true, "发布成功", content);
		} catch (Exception e) {
			if (!(e instanceof OBPMValidateException)) {
				e.printStackTrace();
			    }
			return addActionResult(false, e.getMessage(), null);
		}
	}
	
	/**
	 * 删除评论
	 * @return
	 */
	@DeleteMapping
	@ApiOperation(value = "删除评论", notes = "删除评论")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "commentId",value = "评论id",required = true,paramType = "query",dataType = "string"),
			@ApiImplicitParam(name = "messageId",value = "信息id",required = true,paramType = "query",dataType = "string")
	})
	public Map<String, Object> doDelete(@RequestParam String commentId,@RequestParam String messageId){
		try {
			IUser user = getUser();
		    ParamsTable params = getParams();
//		    String commentId = params.getParameterAsString("commentId");
//		    String messageId = params.getParameterAsString("messageId");
		    String domainId = user.getDomainid();
			commentProcess.doDeleteCommon(commentId,messageId,domainId);
		    return addActionResult(true, "删除成功", null);
		} catch (Exception e) {
		    if (!(e instanceof OBPMValidateException)) {
			    e.printStackTrace();
			    }
			return addActionResult(false, e.getMessage(), null);
		}
	 }
	
	/**
	 * 我回复的评论
	 * @return
	 */
	@GetMapping(value="/my/reply")
	@ApiOperation(value = "我回复的评论", notes = "我回复的评论")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string"),
			@ApiImplicitParam(name = "_currpage", value = "页长度", required = false, paramType = "query", dataType = "string"),
			@ApiImplicitParam(name = "_rowcount", value = "当前页码", required = false, paramType = "query", dataType = "string")
	})

    public Map<String, Object> doQueryIReply() {
	try {
	    ParamsTable params = getParams();
	    String content = params.getParameterAsString("content");
	    Integer page = params.getParameterAsInteger("_currpage");
	    Integer lines = params.getParameterAsInteger("_rowcount");
	    if (page == null || page <= 0)
		page = 1;
	    if (lines == null || lines <= 0)
		lines = 30;
	    IUser user = getUser();
	    DataPackage<Comment> data = commentProcess.queryCommentIReply(content,page, lines, user);
	    return addActionResult(true, "", data);
	} catch (Exception e) {
	    if (!(e instanceof OBPMValidateException)) {
		e.printStackTrace();
	    }
	    return addActionResult(false, e.getMessage(), null);
	}
    }
    
	/**
	 * 回复我的评论
	 * @return
	 */
	@GetMapping(value="/my/receive")
	@ApiOperation(value = "回复我的评论", notes = "回复我的评论")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string"),
			@ApiImplicitParam(name = "_currpage", value = "页长度", required = false, paramType = "query", dataType = "string"),
			@ApiImplicitParam(name = "_rowcount", value = "当前页码", required = false, paramType = "query", dataType = "string")
	})
    public Map<String, Object> doQueryIReceive() {
    	try {
    	    ParamsTable params = getParams();
    	    String content = params.getParameterAsString("content");
    	    Integer page = params.getParameterAsInteger("_currpage");
    	    Integer lines = params.getParameterAsInteger("_rowcount");
    	    if (page == null || page <= 0)
    		page = 1;
    	    if (lines == null || lines <= 0)
    		lines = 30;
    	    IUser user = getUser();
    	    DataPackage<Comment> data = commentProcess.queryCommentIReceive(content,page, lines, user);
    	    return addActionResult(true, "", data);
    	} catch (Exception e) {
    	    if (!(e instanceof OBPMValidateException)) {
    		e.printStackTrace();
    	    }
    	    return addActionResult(false, e.getMessage(), null);
    	}
    }
	
	/**
	 * 消息下的评论列表
	 * @return
	 */
	@GetMapping
	@ApiOperation(value = "消息下的评论列表", notes = "消息下的评论列表")
	@ApiImplicitParams({
			@ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string"),
			@ApiImplicitParam(name = "_currpage", value = "页长度", required = false, paramType = "query", dataType = "string"),
			@ApiImplicitParam(name = "_rowcount", value = "当前页码", required = false, paramType = "query", dataType = "string")
	})
    public Map<String, Object> doQuery() {
    	try {
    	    ParamsTable params = getParams();
    	    String messageId = params.getParameterAsString("messageId");
    	    Integer page = params.getParameterAsInteger("_currpage");
    	    Integer lines = params.getParameterAsInteger("_rowcount");
    	    if (page == null || page <= 0)
    		page = 1;
    	    if (lines == null || lines <= 0)
    		lines = 30;
    	    IUser user = getUser();
    	    DataPackage<Comment> data = commentProcess.queryComments4Message(messageId,page, lines, user);
    	    return addActionResult(true, "", data);
    	} catch (Exception e) {
    		if (!(e instanceof OBPMValidateException)) {
        		e.printStackTrace();
        	    }
    		 return addActionResult(false, e.getMessage(), null);
    	    
    	}
    }

}
