package cn.myapps.message.base.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;

public interface BaseProcess<E> {
	
	/**
	 * 创建实例
	 * @param vo
	 * @return
	 * @throws Exception
	 */
	public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception;
	
	/**
	 * 更新实例
	 * @param vo
	 * @return
	 * @throws Exception
	 */
	public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception;
	
	/**
	 * 根据主键获取实例
	 * @param pk
	 * @return
	 * @throws Exception
	 */
	public AuthtimeValueObject doView(String pk) throws Exception;
	
	/**
	 * 删除实例
	 * @param pk
	 * @throws Exception
	 */
	public void doRemove(String pk) throws Exception;
	
	/**
	 * 批量删除实例
	 * @param pk
	 * @throws Exception
	 */
	public void doRemove(String[] pk) throws Exception;
	
	/**
	 * 查询实例集合
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
	public DataPackage<E> doQuery(ParamsTable params,IUser user) throws Exception;
	
	/**
	 * 查询实例集合
	 * @param params
	 * @param user
	 * @return
	 * @throws Exception
	 */
//	public Collection<E> doSimpleQuery(ParamsTable params,WebUser user) throws Exception;
	

}
