package cn.myapps.message.base.controller;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.tree.UserNode;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.UserAPI;
import cn.myapps.message.util.Web;
import com.bcxin.saas.core.Constants;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.exceptions.SaasBadException;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.Security;
import cn.myapps.message.base.service.BaseProcess;

@RestController(value="MessageBaseController")
public abstract class BaseController<E> {
	protected static final String ACTION_RESULT_KEY = "status";
	protected static final int ACTION_RESULT_VALUE_SUCCESS = 1;
	protected static final int ACTION_RESULT_VALUE_FAULT = 0;
	private final static String PARAM_WEB_USER="PARAM_WEB_USER";
	protected static final String ACTION_MESSAGE_KEY = "message";
	protected static final String ACTION_DATA_KEY = "data";
	
	//将会被Struts2序列化为JSON字符串的对象,用来作为控制层返回结果的容器
	protected Map<String, Object> dataMap = new HashMap<String, Object>();

	protected String[] _selects = null;
	
	protected ParamsTable params;
	
	protected AuthtimeValueObject content = null;
	
	protected BaseProcess<E> process = null;
	
	protected DataPackage<E> datas = null;
	
	@Autowired  
	protected HttpServletRequest request;

	@Autowired
	protected HttpServletResponse response;
	
	@Autowired
	protected HttpSession session;
	@Autowired
	protected DistributedCacheProvider distributedCacheProvider;
	
	public String[] get_selects() {
		return _selects;
	}
	public void set_selects(String[] selects) {
		_selects = selects;
	}
	public ParamsTable getParams() {
		if (params == null) {
			params = ParamsTable.convertHTTP(this.request);

			params.setSessionid(this.request.getSession().getId());

			if (params.getParameter("_pagelines") == null){
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}
		return params;
	}
	
	public ParamsTable getParams(HttpServletRequest request) {
		if (params == null) {
			params = ParamsTable.convertHTTP(request);

			params.setSessionid(request.getSession().getId());

			if (params.getParameter("_pagelines") == null){
				params.setParameter("_pagelines", Web.DEFAULT_LINES_PER_PAGE);
			}
		}
		return params;
	}
	
	public String getUserId() {
		String userId = Security.getUserIdFromToken(request);
		if (userId == null){
			userId = Security.getDebugUserIdFromToken(request);
		}
		return userId;
	}
	
	public AuthtimeValueObject getContent() {
		return content;
	}
	public void setContent(AuthtimeValueObject content) {
		this.content = content;
	}
	public DataPackage<E> getDatas() {
		return datas;
	}
	public void setDatas(DataPackage<E> datas) {
		this.datas = datas;
	}
	
	public WebUser getUser() throws Exception {
		if (request.getAttribute(PARAM_WEB_USER) == null) {
			WebUser user = new WebUser();
			String userId = Security.getUserIdFromToken(request);
			if (StringUtils.isEmpty(userId)) {
				return null;
			}

			Map<String, Object> userMap =
					this.distributedCacheProvider.get(Constants.getUserMapRedisKey(userId), () -> {
						FeignConfig.ACCESS_TOKEN = getTokenByCookie(request, Security.ACCESS_TOKEN);
						if (StringUtils.isEmpty(FeignConfig.ACCESS_TOKEN)) {
							FeignConfig.ACCESS_TOKEN = Security.getToken(userId);
						}
						UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
						Map<String, Object> userMap_1 = null;
						try {
							userMap_1 = (Map<String, Object>) userAPI.getLoginUser().getData();
						} catch (Exception e) {
							throw new SaasBadException("获取用户信息无效", e);
						}

						return userMap_1;
					}, 5*60);


			user.setId(userId);
			user.setName((String) userMap.get("name"));
			user.setDomainid((String) userMap.get("domainId"));
			user.setDefaultDepartment((String) userMap.get("deptId"));
			request.setAttribute(PARAM_WEB_USER, user);
		}

		return (WebUser) request.getAttribute(PARAM_WEB_USER);
	}
	
	public BaseProcess<E> getProcess() {
		return process;
	}
	
	 /**
     * Struts2序列化指定属性时，必须有该属性的getter方法
     * @return
     */
    public Map<String, Object> getDataMap() {
        return dataMap;
    }
    
    /**
     * 添加Action处理结果
     * @param isSuccess
     * 		是否成功处理
     * @param message
     * 		返回消息
     * @param data
     * 		返回数据
     */
    public Map<String, Object> addActionResult(boolean isSuccess,String message,Object data){
    	dataMap.put(ACTION_RESULT_KEY, isSuccess?ACTION_RESULT_VALUE_SUCCESS : ACTION_RESULT_VALUE_FAULT );
    	dataMap.put(ACTION_MESSAGE_KEY, message);

    	if(data != null){
    		dataMap.put(ACTION_DATA_KEY, data);
    	}
    	return dataMap;
    }
	
	private WebUser getAnonymousUser(){
		WebUser vo = new WebUser();
		vo.setId("1234-5678-90");
		vo.setName("测试用户");
//		vo.setLoginno("test");
		vo.setLoginpwd("");

		return vo;
	}

	public String getTokenByCookie(HttpServletRequest request, String key){
		String accessToken = null;
    	try{
			accessToken = request.getParameter(key);
			if (accessToken == null) {
				accessToken = request.getHeader(key);
			}

			if (accessToken == null) {
				Cookie[] cookies = request.getCookies();
				if (cookies == null){
					return null;
				}
				for (Cookie cookie : cookies) {
					String name = cookie.getName();
					if (key.equals(name)) {
						accessToken = cookie.getValue();
					}
				}
			}
		}catch (Exception e){
    		e.printStackTrace();
		}

		return accessToken;
	}

}
