package cn.myapps.message.base.action;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import cn.myapps.common.util.*;
import cn.myapps.message.util.JsonUtil;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;


public class MessageUploadServlet extends HttpServlet {

    /**
	 * 
	 */
	private static final long serialVersionUID = 8489796601570334271L;

	// 通过doget请求处理
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	try {
	    processRequest(request, response);
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    // 通过dopost请求处理
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
	try {
	    processRequest(request, response);
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
		Map<String, String> resultInfo = null;
		try {
			DiskFileItemFactory fac = new DiskFileItemFactory();
			ServletFileUpload upload = new ServletFileUpload(fac);
			upload.setHeaderEncoding("UTF-8");
			Map<String, FileItem> map = new HashMap<String, FileItem>();
			try {
				List<FileItem> fileList = upload.parseRequest(request);
				for (FileItem item : fileList) {
					map.put(item.getFieldName(), item);
				}
			} catch (FileUploadException ex) {
				return;
			}

//			// 配置文件获取相对路径
//			String uploadPath = DefaultProperty.getProperty(
//					"myapps.message.upload.path", "/uploads/message/");
//
//			// 服务器目录的绝对路径
//			String realPath = this.getServletConfig().getServletContext()
//					.getRealPath("");
//
//			// 目录的相对路径
//			String relativePath = uploadPath + DateUtil.getCurDateStr("yyyy");
//
//			// 存放此文件的绝对路径
//			String savePath = realPath + relativePath;

			// 获得文件保存的真实路径
			String  workRootPath  =  PropertyUtil.getPath();
			String savePath =workRootPath;
			// 拼接好文件要保存的真实文件夹
			savePath += "/uploads/message/";

			String relativePath="/uploads/message/";

			File f1 = new File(savePath);
			if (!f1.exists()) {
				f1.mkdirs();
			}

			resultInfo = new HashMap<String, String>();

			FileItem fileData = map.get("file");
			String id = SequenceGenerator.getSequence();
			String fileName = fileData.getName();
			long size = fileData.getSize();
			resultInfo.put("id", id);
			resultInfo.put("name", fileName);
			resultInfo.put("size", String.valueOf(size));

			// 扩展名格式：
			int index = fileName.lastIndexOf(".");
			String extName = fileName.substring(index);

			// 文件类型：
			if (extName.indexOf("gif") > 0 || extName.indexOf("jpg") > 0
					|| extName.indexOf("jpeg") > 0
					|| extName.indexOf("bmp") > 0 || extName.indexOf("png") > 0) {
				resultInfo.put("type", "image");
			} else {
				resultInfo.put("type", "file");
			}

			resultInfo.put("extName", extName);
			// 生成文件名：
			File saveFile = new File(savePath + "/" + id + extName);
			resultInfo.put("url", relativePath+ "/" + id + extName);

			try {
				// 文件上传到服务器
				fileData.write(saveFile);
			} catch (Exception e) {
				e.printStackTrace();
			}
			// 转换为SWF文件
			try {
				//生成文件转换任务
				String rootPath = PropertyUtil.getPath();
				FileWriteUtil.writeKmConvertTask(rootPath,id,saveFile.getPath());
			} catch (Exception e) {
				e.printStackTrace();
			}
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				PrintWriter writer = encodehead(request, response);
				String result = JsonUtil.toJson(resultInfo);
				writer.print(result);
				writer.flush();
				writer.close();
//				PersistenceUtils.closeSessionAndConnection();
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}



	/**
     * Ajax辅助方法 获取 PrintWriter
     * 
     * @return
     * @throws IOException
     * @throws IOException
     *             request.setCharacterEncoding("utf-8");
     *             response.setContentType("text/html; charset=utf-8");
     */
    private PrintWriter encodehead(HttpServletRequest request, HttpServletResponse response) throws IOException {
	request.setCharacterEncoding("utf-8");
	response.setContentType("text/html; charset=utf-8");
	return response.getWriter();
    }

}
