package cn.myapps.conf;

import cn.myapps.common.controller.Resource;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Collection;

@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
@Component
public interface UserAPI {
    /**
     * 根据部门获取用户
     */
    @GetMapping(value = "/api/runtime/users/department/{departmentid}/users")
    Collection getDepartmentUsers(@PathVariable String departmentid);

    /**
     * 根据获取用户
     */
    @GetMapping(value = "/api/runtime/users/domain/{domainid}/users")
    Collection getDomainUsers(@PathVariable String domainid);

    @GetMapping(value = "/api/runtime/users/myprofile")
    Resource getLoginUser() throws Exception;


    @GetMapping(value = "/api/runtime/users/profile")
    Resource getUserById(@RequestParam(required=false) String id) throws Exception;

    @GetMapping(value = "/api/runtime/department/list")
    Resource getAllDepartmentUsers();
}


