package cn.myapps.conf;

import org.springframework.boot.web.servlet.FilterRegistrationBean;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import cn.myapps.runtime.message.service.MessageRunTimeService;
import cn.myapps.runtime.message.service.MessageRunTimeServiceImpl;
import org.springframework.core.Ordered;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

/**
 * RunTime Service层配置类
 * 
 * @author ahan
 *
 */
@Configuration
public class RunTimeServiceConfig {
	
	@Bean
	public MessageRunTimeService messageService(){
		return new MessageRunTimeServiceImpl();
	}

	@Bean
	public FilterRegistrationBean corsFilter() {
		FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
		final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
		final CorsConfiguration config = new CorsConfiguration();
		config.setAllowCredentials(true); // 允许cookies跨域
		config.addAllowedOriginPattern("*");
		//config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
		config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
		config.setMaxAge(18000L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
		config.addAllowedMethod("*");// 允许提交请求的方法，*表示全部允许
		source.registerCorsConfiguration("/**", config);
		filterRegistrationBean.setFilter(new CorsFilter(source));
		filterRegistrationBean.setOrder(Ordered.HIGHEST_PRECEDENCE);

		return filterRegistrationBean;
	}

	@Bean
	public Snowflake snowflake() {
		return IdUtil.createSnowflake(0, 1);
	}
}
