package cn.myapps.conf;

import cn.myapps.message.base.action.MessageUploadServlet;
import cn.myapps.runtime.message.util.PersistenceHandlerInterceptor;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import java.util.List;

@Configuration
public class MyappsMvcConfig extends WebMvcConfigurerAdapter {

	@Bean
	public CommonsMultipartResolver multipartResolver() {
		CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver();
		multipartResolver.setMaxUploadSize(-1);// 不限制上传文件大小
		return multipartResolver;
	}

	@Override//全局统一异常处理
	public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> resolvers) {
		resolvers.add(new CommonsExceptionResolver());
	}

	@Override
	public void addInterceptors(InterceptorRegistry registry) {
		super.addInterceptors(registry);

		//DAO资源清理拦截器,关闭数据库连接等
		registry.addInterceptor(new PersistenceHandlerInterceptor()).addPathPatterns("/**")
				.excludePathPatterns("/static/**");
	}

	@Bean // FrontFileAndImageUploadServlet 文件上传
	public ServletRegistrationBean getServletRegistrationBean7() {
		ServletRegistrationBean bean = new ServletRegistrationBean(new MessageUploadServlet());
		bean.addUrlMappings("/api/message/servlet/upload"); // 访问路径值
		return bean;
	}
}
