package cn.myapps.conf;

import cn.myapps.common.util.StringUtil;
import com.bcxin.saas.core.utils.ExceptionUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;

public class CommonsExceptionResolver implements HandlerExceptionResolver {

    private static final Logger log = LoggerFactory.getLogger(CommonsExceptionResolver.class);

    @Override
    public ModelAndView resolveException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) {
        try {
            e.printStackTrace();

            cn.myapps.message.util.ConnectionManager.closeConnection();

            httpServletResponse.setContentType("text/json;charset=utf-8");
            httpServletResponse.resetBuffer();
            httpServletResponse.setStatus(500);

            PrintWriter writer = httpServletResponse.getWriter();
            JSONObject json = new JSONObject();
            json.put("errcode", 500);
            if(StringUtil.isBlank(e.getMessage())){
                json.put("errmsg", "2.系统异常，请联系管理员！");
            } else {
                json.put("errmsg", e.getMessage());
            }

            json.put("detail", ExceptionUtils.getStackMessage(e));

            writer.print(json);
        } catch (Exception ex){
            ex.printStackTrace();
        }
        return null;
    }
}
