package cn.myapps.common.model;

import com.fasterxml.jackson.annotation.JsonIgnore;

import java.io.Serializable;

/**
 * The base value object.
 */
public abstract class AuthtimeValueObject implements Serializable {
	private static final long serialVersionUID = 6090880810921830021L;

	/**
	 * @uml.property  name="sortId"
	 */
	@JsonIgnore
	protected String sortId;

	@JsonIgnore
	protected String applicationid;

	/**
	 */
	@JsonIgnore
	protected String domainid;

	protected String id;

	@JsonIgnore
	protected int version;
	
	@JsonIgnore
	protected boolean isLazyLoad = true;

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public String getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return java.lang.String
	 */
	public String getSortId() {
		return sortId;
	}

	/**
	 * @param sortId
	 *            the sortId to set
	 */
	public void setSortId(String sortId) {
		this.sortId = sortId;
	}

	/**
	 * @return java.lang.String
	 */
	public String getApplicationid() {
		return applicationid;
	}

	/**
	 * @param applicationid
	 *            the applicationid to set
	 */
	public void setApplicationid(String applicationid) {
		this.applicationid = applicationid;
	}

	public String getDomainid() {
		return domainid;
	}

	public void setDomainid(String domainid) {
		this.domainid = domainid;
	}

	@Override
	protected Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

	@JsonIgnore
	public boolean isLazyLoad() {
		return isLazyLoad;
	}

	public void setLazyLoad(boolean isLazyLoad) {
		this.isLazyLoad = isLazyLoad;
	}

	@Override
	public String toString() {
		return "ValueObject{" +
				"sortId='" + sortId + '\'' +
				", applicationid='" + applicationid + '\'' +
				", domainid='" + domainid + '\'' +
				", id='" + id + '\'' +
				", version=" + version +
				", isLazyLoad=" + isLazyLoad +
				'}';
	}
}
