package cn.myapps.caches.responses;

import com.bcxin.web.commons.responses.ResponseAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.Getter;

@Getter
public class CacheResponse extends ResponseAbstract {
    @Schema(name = "data",title = "缓存数据")

    private final Object data;
    @Schema(name = "code",title = "业务编码: 可空, 用于区分不同系统")
    private final String code;

    public CacheResponse(String code, Object data) {
        this.code = code;
        this.data = data;
    }

    public static CacheResponse create(String code, Object data) {
        return new CacheResponse(code, data);
    }
}
