package cn.myapps.caches.requests;

import com.bcxin.web.commons.requests.RequestAbstract;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

@Data
public class CacheRequest extends RequestAbstract {
    @Schema(name = "key",title = "缓存的key, 根据业务指定唯一key")
    private String key;
    @Schema(name = "code",title = "业务编码: 可空, 用于区分不同系统")
    private String code;
    @Schema(name = "data",title = "缓存数据")
    private Object data;
    @Schema(name = "expiredInSeconds",title = "希望缓存的时长(单位: 秒)")
    private Integer expiredInSeconds;

    @Override
    public void validate() {

    }
}
