package cn.myapps;

import java.util.Collection;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import cn.myapps.base.web.WebUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

import com.jayway.jsonpath.PathNotFoundException;

import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import net.sf.json.JSONObject;

/**
 * 定义了基本的运行时Restful接口信息，用于处理共同的错误返回码以及其他信息。<br/>
 * 对应资源的Restful接口需要实现这个抽象类并定义为一个 {@link Component}便可由spring自动扫描装配。
 * 
 * @author ahan
 *
 */
@RestController
public abstract class AbstractRuntimeController {

	@Autowired
	protected HttpServletRequest request;

	@Autowired
	protected HttpSession session;

	private String domain;

	/**
	 * Retrieve WebUser Object.
	 * 
	 * @return The current WebUser Object.
	 * @throws Exception
	 */
	protected WebUser getUser() throws Exception {
		WebUser user = new WebUser();

//		if (session == null || AuthTimeServiceManager.getWebUser(request) == null)
//			user = getAnonymousUser();
//		else
//			user = AuthTimeServiceManager.getWebUser(request);
		String userId = Security.getUserIdFromToken(request);
		user.setId(userId);
		return user;
	}

	protected String getUserId() throws Exception {

		String userId = null;
		try {
			userId = Security.getUserIdFromToken(request);
			if (userId == null) {
				userId = Security.getDebugUserIdFromToken(request);
			}
		} catch (Exception e) {
			return null;
		}

		return userId;
	}

	/**
	 * Retrieve the ParamsTable
	 * 
	 * @return ParamsTable
	 */
	public ParamsTable getParams() {
		ParamsTable pm = ParamsTable.convertHTTP(request);

		// put the domain id to parameters table.
//		if (getDomain() != null)
//			pm.setParameter("domainid", getDomain());

		// put the page line count id to parameters table.
		if (pm.getParameter("_pagelines") == null)
			pm.setParameter("_pagelines", 10);

		String parentId = pm.getParameterAsString("parentId");
		if (!StringUtil.isBlank(parentId)) {
			pm.setParameter("relateid", parentId);
			pm.setParameter("parentid", parentId);
		}
		String parentid = pm.getParameterAsString("parentid");
		if (!StringUtil.isBlank(parentid)) {
			pm.setParameter("relateid", parentid);
			pm.setParameter("parentId", parentid);
		}

		String isRelate = pm.getParameterAsString("isRelate");
		if (StringUtil.isBlank(isRelate) || !"true".equals(isRelate)) {
			pm.removeParameter("parentId");
			pm.removeParameter("parentid");
		}

		return pm;
	}

	/**
	 * Get the domain.
	 * 
	 * @return The domain.
	 */
//	public String getDomain() {
//		if (StringUtils.isNotBlank(domain))
//			return domain;
//		try {
//			return getUser().getDomainid();
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		return "";
//	}

	protected Resource success(String errmsg, Object data) {
		return new Resource(0, errmsg, data, null);
	}

	protected Resource successWithPagination(String errmsg, Object data, int page, int page_lines, int row_count) {
		JSONObject json = new JSONObject();
		json.put("data", data);
		json.put("page", page);
		json.put("page_lines", page_lines);
		json.put("row_count", row_count);
		resourceValue = new Resource(0, errmsg, json, null);
		return resourceValue;
	}

	protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
		return new Resource(errcode, errmsg, null, errors);
	}

	private Resource resourceValue;

	public Resource getResourceValue() {
		return resourceValue;
	}

	public void setResourceValue(Resource resourceValue) {
		this.resourceValue = resourceValue;
	}

	/**
	 * 资源未找到的异常，返回404的状态，且返回错误信息。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(ResourceNotFoundException.class)
	@ResponseStatus(HttpStatus.NOT_FOUND)
	public Resource resourceNotFound(ResourceNotFoundException e) {
		return error(404, "Not Found", null);
	}

	/**
	 * 运行时异常，服务器错误，返回500状态，返回服务器错误信息。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(RuntimeException.class)
	@ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
	public Resource error(RuntimeException e) {
		e.printStackTrace();
		return error(500, "Server Error", null);
	}

	/**
	 * 资源未找到的异常，返回404的状态，且返回错误信息。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(OBPMValidateException.class)
	@ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
	public Resource serverError(OBPMValidateException e) {
		e.printStackTrace();
		return error(500, "Server Error", null);
	}

	/**
	 * 传参错误。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(MethodArgumentTypeMismatchException.class)
	@ResponseStatus(HttpStatus.NOT_ACCEPTABLE)
	public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
		return error(40035, "不合法的参数", null);
	}

	/**
	 * 请求包体解析错误。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(PathNotFoundException.class)
	@ResponseStatus(HttpStatus.NOT_ACCEPTABLE)
	public Resource requestbodyError(PathNotFoundException e) {
		e.printStackTrace();
		return error(406, "请求包体参数出错", null);
	}

}
