/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.runtime.message.service;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.util.StringUtil;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notice.service.NoticeProcessBean;
import cn.myapps.runtime.message.service.MessageRunTimeService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class MessageRunTimeServiceImpl
implements MessageRunTimeService {
    @Override
    public Map<String, Object> getNotices(String userId, Integer pageNo, Integer linesPerPage) throws Exception {
        if (pageNo == null || pageNo <= 0) {
            pageNo = 1;
        }
        if (linesPerPage == null || linesPerPage <= 0) {
            linesPerPage = 30;
        }
        NoticeProcessBean process = new NoticeProcessBean();
        DataPackage<Notice> data = process.queryNoticeByCondition("", null, Collections.EMPTY_LIST, pageNo, linesPerPage, userId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList datasList = new ArrayList();
        Iterator iterator = data.datas.iterator();
        while (iterator.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Notice notice = (Notice)iterator.next();
            map.put("id", notice.getId());
            map.put("domainid", notice.getDomainid());
            map.put("createTime", notice.getCreateTime());
            map.put("lazyLoad", notice.isLazyLoad());
            String linkParams = notice.getLinkParams();
            JSONObject linkParamsJson = null;
            if (!StringUtil.isBlank((String)linkParams)) {
                linkParamsJson = JSONObject.fromObject((Object)linkParams);
            }
            map.put("linkParams", linkParamsJson);
            map.put("module", notice.getModule());
            map.put("read", notice.isRead());
            map.put("subjectType", notice.getSubjectType());
            map.put("summary", notice.getSummary());
            map.put("toUserId", notice.getToUserId());
            map.put("version", notice.getVersion());
            datasList.add(map);
        }
        result.put("datas", datasList);
        result.put("linesPerPage", data.getLinesPerPage());
        result.put("pageCount", data.getPageCount());
        result.put("pageNo", data.getPageNo());
        result.put("rowCount", data.getRowCount());
        return result;
    }

    @Override
    public void set2Read(String id) throws Exception {
        NoticeProcessBean process = new NoticeProcessBean();
        process.setNotice2Read(id);
    }

    @Override
    public void setAll2Read(String userId) throws Exception {
        NoticeProcessBean process = new NoticeProcessBean();
        process.markAllAsRead(userId);
    }

    @Override
    public void delete(String[] ids) throws Exception {
        NoticeProcessBean process = new NoticeProcessBean();
        process.doRemove(ids);
    }
}

