/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.util;

import cn.myapps.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;

public class JsonUtil {
    public static Collection<Object> toCollection(String JSONStr) {
        ArrayList<Object> rtn = new ArrayList<Object>();
        JSONArray array = JSONArray.fromObject((Object)JSONStr);
        for (int i = 0; i < array.size(); ++i) {
            Object obj = array.get(i);
            if (obj instanceof JSONObject) {
                rtn.add(JsonUtil.toMap((JSONObject)obj));
                continue;
            }
            rtn.add(obj);
        }
        return rtn;
    }

    public static Collection<Object> toCollection(String JSONStr, Class<?> objClass) {
        JSONArray array = JSONArray.fromObject((Object)JSONStr);
        List list = JSONArray.toList((JSONArray)array, objClass);
        return list;
    }

    public static Map<String, Object> toMap(String jsonStr) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonStr);
        return JsonUtil.toMap(jsonObject);
    }

    private static Map<String, Object> toMap(JSONObject jsonObject) {
        HashMap<String, Object> rtn = new HashMap<String, Object>();
        if (jsonObject.isNullObject()) {
            return null;
        }
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object obj = jsonObject.get(key);
            if (obj instanceof JSONArray) {
                rtn.put(key, JsonUtil.toArray((JSONArray)obj));
                continue;
            }
            if (obj instanceof JSONObject) {
                rtn.put(key, JsonUtil.toMap((JSONObject)obj));
                continue;
            }
            if (obj instanceof String) {
                rtn.put(key, StringUtil.dencodeHTML((String)((String)obj)));
                continue;
            }
            rtn.put(key, obj);
        }
        return rtn;
    }

    private static Object[] toArray(JSONArray jsonArray) {
        Object[] rtn = new Object[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object obj = jsonArray.get(i);
            rtn[i] = obj instanceof JSONObject ? JsonUtil.toMap((JSONObject)obj) : obj;
        }
        return rtn;
    }

    public static Object toBean(String jsonStr, Class<?> objClass) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonStr);
        Object obj = JSONObject.toBean((JSONObject)jsonObject, objClass);
        return obj;
    }

    public static String collection2Json(Collection<?> collection) {
        return JsonUtil.collection2Json(collection, new String[0]);
    }

    public static String collection2Json(Collection<?> collection, String[] excludes) {
        JsonConfig jsonConfig = new JsonConfig();
        JSONArray jsonArray = JSONArray.fromObject(collection, (JsonConfig)jsonConfig);
        return jsonArray.toString();
    }

    public static String toJson(Object obj) {
        JsonConfig config = new JsonConfig();
        JSONObject jsonObject = JSONObject.fromObject((Object)obj);
        return jsonObject.toString();
    }

    public static void main(String[] args) throws Exception {
    }
}

