/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.util;

import cn.myapps.common.util.DbUtil;
import cn.myapps.common.util.SpringApplicationContextUtil;
import com.bcxin.saas.core.components.SecondCacheProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;

public class ConnectionManager {
    public static final String DS_DEFAULT_CONNECTION = "DS:DS_DEFAULT:CONNECTION";
    public static String dbType = "MYSQL";
    private static volatile int closeCount = 0;

    public static Connection getConnection() throws Exception {
        Connection threadLocal = ConnectionManager.getRuntimeDefaultDBConn();
        Connection conn = null;
        if (threadLocal != null) {
            conn = threadLocal;
        }
        if ((conn == null || conn.isClosed()) && (conn = ConnectionManager.newConnection()) != null) {
            ConnectionManager.setRuntimeDefaultDBConn(conn);
        }
        return conn;
    }

    private static Connection newConnection() throws Exception {
        DataSource dataSource = (DataSource)SpringApplicationContextUtil.getBean(DataSource.class);
        if (dataSource != null) {
            Connection conn = dataSource.getConnection();
            dbType = DbUtil.getDBType((Connection)conn);
            return conn;
        }
        return null;
    }

    public static void closeStatement(Statement stmt) throws Exception {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException se) {
            throw new Exception("SQL Exception while closing Statement : \n" + se);
        }
    }

    public static void closeConnection() throws Exception {
        try {
            Connection threadLocal = ConnectionManager.getRuntimeDefaultDBConn();
            if (threadLocal != null) {
                if (!threadLocal.isClosed()) {
                    ++closeCount;
                    threadLocal.close();
                }
                threadLocal = null;
                ConnectionManager.setRuntimeDefaultDBConn(null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static Connection getRuntimeDefaultDBConn() throws Exception {
        SecondCacheProvider secondCacheProvider = (SecondCacheProvider)SpringApplicationContextUtil.getBean(SecondCacheProvider.class);
        Connection connection = (Connection)secondCacheProvider.getIfPresent(DS_DEFAULT_CONNECTION);
        return connection;
    }

    private static void setRuntimeDefaultDBConn(Connection connection) {
        SecondCacheProvider secondCacheProvider = (SecondCacheProvider)SpringApplicationContextUtil.getBean(SecondCacheProvider.class);
        if (connection == null) {
            secondCacheProvider.removeData(DS_DEFAULT_CONNECTION);
        } else {
            secondCacheProvider.setData(DS_DEFAULT_CONNECTION, (Object)connection);
        }
    }
}

