/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.notification.controller;

import cn.myapps.common.util.Security;
import cn.myapps.message.base.controller.BaseController;
import cn.myapps.message.notification.model.Notification;
import cn.myapps.message.notification.service.NotificationProcess;
import cn.myapps.message.notification.service.NotificationProcessBean;
import com.bcxin.saas.core.components.DistributedCacheProvider;
import com.bcxin.saas.core.components.JsonProvider;
import com.bcxin.saas.core.utils.ExceptionUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller(value="NotificationAction")
@RequestMapping(value={"/api/message/notification"})
@Scope(value="prototype")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@Api(tags={"\u6d88\u606f\u901a\u77e5\u6a21\u5757"})
public class NotificationController
extends BaseController<Notification> {
    @Autowired
    private NotificationProcess notificationProcess;
    private final DistributedCacheProvider distributedCacheProvider;
    private final JsonProvider jsonProvider;

    public NotificationController(DistributedCacheProvider distributedCacheProvider, JsonProvider jsonProvider) {
        this.distributedCacheProvider = distributedCacheProvider;
        this.jsonProvider = jsonProvider;
        this.content = new Notification();
        this.process = new NotificationProcessBean();
    }

    @GetMapping(value={"/login"})
    @ApiOperation(value="\u7528\u6237\u767b\u5f55\u65f6\uff0c\u83b7\u53d6\u6d88\u606f\u901a\u77e5", notes="\u7528\u6237\u767b\u5f55\u65f6\uff0c\u83b7\u53d6\u6d88\u606f\u901a\u77e5")
    public Map<String, Object> sendMessageNotificationWhenLogin() {
        try {
            String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            String sessionKey = String.format("sendMessageNotificationWhenLogin:%s", userId);
            JSONObject datas = (JSONObject)this.request.getSession().getAttribute(sessionKey);
            if (datas == null) {
                datas = this.notificationProcess.sendMessageNotificationWhenLogin(userId);
                this.request.getSession().setAttribute(sessionKey, (Object)datas);
            }
            return this.addActionResult(true, "", datas);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, "\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", null);
        }
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u6d88\u606f\u4e2d\u5fc3\u901a\u77e5", notes="\u83b7\u53d6\u6d88\u606f\u4e2d\u5fc3\u901a\u77e5")
    public Map<String, Object> sendMessageNotification2User() {
        try {
            String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            String sessionKey = String.format("sendMessageNotification2User:%s", userId);
            String result = (String)this.distributedCacheProvider.get(sessionKey, () -> {
                String datas = null;
                try {
                    JSONObject content = this.notificationProcess.sendMessageNotification2User(userId);
                    datas = this.jsonProvider.getJson((Object)content);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return datas;
            }, 120L);
            JSONObject data = (JSONObject)this.jsonProvider.getData(result, JSONObject.class);
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            return this.addActionResult(false, "\u83b7\u53d6\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", null);
        }
    }

    @DeleteMapping(value={"/clear"})
    @ApiOperation(value="\u6e05\u7a7a\u6d88\u606f\u4e2d\u5fc3\u901a\u77e5", notes="\u6e05\u7a7a\u6d88\u606f\u4e2d\u5fc3\u901a\u77e5")
    public Map<String, Object> clearNotification() {
        try {
            String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            this.notificationProcess.clearMessageNotification(null, null, null, userId);
            return this.addActionResult(true, "", this.datas);
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/count"})
    @ApiOperation(value="\u83b7\u5f97\u6d88\u606f\u603b\u6570", notes="\u83b7\u5f97\u6d88\u606f\u603b\u6570")
    public Map<String, Object> getNotificationCount() {
        try {
            String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            String notifyCacheKey = String.format("getNotificationCount:%s", userId);
            String cacheData = (String)this.distributedCacheProvider.get(notifyCacheKey, () -> {
                try {
                    JSONObject result = this.notificationProcess.getNotificationCount(userId);
                    return this.jsonProvider.getJson((Object)result);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }, 10L);
            return this.addActionResult(true, "", cacheData == null ? null : this.jsonProvider.getData(cacheData, JSONObject.class));
        }
        catch (Exception e) {
            return this.addActionResult(false, ExceptionUtils.getStackMessage((Throwable)e), null);
        }
    }

    @PostMapping
    public void doCreate(@RequestBody Notification notification) {
        try {
            this.notificationProcess.doCreate(notification);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Notice-->" + notification);
    }
}

