/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.notice.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.notice.dao.NoticeDAO;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notice.service.NoticeProcess;
import cn.myapps.message.notification.dao.NotificationDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NoticeProcessBean
implements BaseProcess<Notice>,
NoticeProcess {
    @Autowired
    private NoticeDAO noticeDAO;
    @Autowired
    private NotificationDAO notificationDAO;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public Notice doCreate(Notice vo) throws Exception {
        return (Notice)this.noticeDAO.save(vo);
    }

    @Override
    public List<Notice> doCreateList(List<Notice> voList) {
        return this.noticeDAO.saveAll(voList);
    }

    @Override
    public Notice findNoticeById(String noticeId, String userId) throws Exception {
        Notice notice = null;
        try {
            notice = this.noticeDAO.findById(noticeId).orElse(notice);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return notice;
    }

    @Override
    public DataPackage<Notice> queryNoticeByCondition(final String summary, final Boolean readStatus, final Collection<Integer> subjectTypes, int page, int lines, final String userId) throws Exception {
        DataPackage dp = new DataPackage();
        dp.setPageNo(page);
        dp.setLinesPerPage(lines);
        PageRequest pageable = PageRequest.of((int)(page - 1), (int)lines);
        Specification<Notice> specification = new Specification<Notice>(){

            public Predicate toPredicate(Root<Notice> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                ArrayList<Object> predicates = new ArrayList<Object>();
                if (userId != null && !userId.equals("")) {
                    predicates.add(cb.equal((Expression)root.get("toUserId"), (Object)userId));
                }
                if (readStatus != null) {
                    if (readStatus.booleanValue()) {
                        predicates.add(cb.equal((Expression)root.get("read"), (Object)1));
                    } else {
                        predicates.add(cb.equal((Expression)root.get("read"), (Object)0));
                    }
                }
                if (!CollectionUtils.isEmpty((Collection)subjectTypes)) {
                    CriteriaBuilder.In subjectTypesInClause = cb.in((Expression)root.get("subjectType"));
                    for (Integer iValue : subjectTypes) {
                        subjectTypesInClause.value((Object)iValue);
                    }
                    predicates.add(subjectTypesInClause);
                }
                if (!StringUtil.isBlank((String)summary)) {
                    predicates.add(cb.like((Expression)root.get("summary"), "%" + summary + "%"));
                }
                Predicate[] pre = new Predicate[predicates.size()];
                query.where(predicates.toArray(pre));
                query.orderBy(new Order[]{cb.desc((Expression)root.get("createTime"))});
                return cb.and(predicates.toArray(pre));
            }
        };
        Page all = this.noticeDAO.findAll((Specification)specification, (Pageable)pageable);
        long count = this.noticeDAO.count((Specification)specification);
        dp.setDatas((Collection)all.getContent());
        dp.setRowCount((int)count);
        return dp;
    }

    @Override
    public void setNotice2Read(String noticesId) throws Exception {
        try {
            if (!StringUtil.isBlank((String)noticesId)) {
                for (String id : noticesId.split(",")) {
                    this.noticeDAO.setNotice2Read(id);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void markAllAsRead(String receiverId) throws Exception {
        try {
            this.noticeDAO.markAllAsRead(receiverId);
            this.notificationDAO.deleteAllByMessageId(receiverId);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void removeByDocId(String docId, String userId) throws Exception {
        DataPackage<Notice> noticeDatas = this.queryNoticeByCondition(null, null, Collections.EMPTY_LIST, 1, Integer.MAX_VALUE, userId);
        for (Notice notice : noticeDatas.datas) {
            JSONObject json = JSONObject.fromObject((Object)notice.getLinkParams());
            String noticeDocId = (String)json.get("_docid");
            if (!docId.equals(noticeDocId)) continue;
            this.noticeDAO.deleteById(notice.getId());
        }
    }

    @Override
    public List<Map<String, Object>> queryModuleNoticeByCondition(String summary, Boolean readStatus, String userId) throws Exception {
        ArrayList<String> params = new ArrayList<String>();
        params.add(userId);
        String sql = "SELECT a.MODULE as module,a.SUMMARY as summary,GROUP_CONCAT(DISTINCT a.SUBJECT_TYPE) as subjectType,SUM((case when IS_READ=0 then 1 else 0 end)) as countOfUnread  FROM mc_notice a where a.TO_USER_ID=?";
        if (!StringUtil.isBlank((String)summary)) {
            sql = sql + " and a.SUMMARY like concat('%', ?, '%')";
            params.add(summary);
        }
        sql = sql + " GROUP BY a.MODULE order by a.CREATE_TIME desc";
        List result = this.jdbcTemplate.queryForList(sql, params.toArray());
        return result;
    }

    @Override
    public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doView(String pk) throws Exception {
        return null;
    }

    @Override
    public void doRemove(String pk) throws Exception {
        this.noticeDAO.deleteById(pk);
    }

    @Override
    public void doRemove(String[] pk) throws Exception {
    }

    @Override
    public DataPackage<Notice> doQuery(ParamsTable params, IUser user) throws Exception {
        return null;
    }
}

