/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.notice.controller;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Snowflake;
import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.StringUtil;
import cn.myapps.message.base.controller.BaseController;
import cn.myapps.message.notice.model.Notice;
import cn.myapps.message.notice.service.NoticeProcess;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.saas.core.exceptions.SaasBadException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller(value="NoticeAction")
@RequestMapping(value={"/api/message/notice"})
@Scope(value="prototype")
@Api(tags={"\u901a\u77e5\u6a21\u5757"})
public class NoticeController
extends BaseController<Notice> {
    private static final Logger log = LoggerFactory.getLogger(NoticeController.class);
    @Autowired
    private NoticeProcess noticeProcess;
    @Autowired
    private Snowflake snowflake;

    public NoticeController() {
        this.content = new Notice();
    }

    @GetMapping
    @ApiOperation(value="\u83b7\u53d6\u4e8b\u9879\u63d0\u9192\u901a\u77e5", notes="\u83b7\u53d6\u4e8b\u9879\u63d0\u9192\u901a\u77e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="readStatus", value="\u9605\u8bfb\u72b6\u6001", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="_currpage", value="\u9875\u957f\u5ea6", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="_rowcount", value="\u5f53\u524d\u9875\u7801", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="type", value="\u540e\u7eed\u8865\u5145", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doQuery() {
        try {
            ParamsTable params = this.getParams();
            String summary = params.getParameterAsString("summary");
            Boolean isRead = null;
            String readStatus = params.getParameterAsString("readStatus");
            if (!StringUtil.isBlank((String)readStatus) && "0".equals(readStatus)) {
                isRead = false;
            }
            String subjectType = params.getParameterAsString("type");
            ArrayList<Integer> selectedSubjectTypes = new ArrayList();
            if (!StringUtil.isBlank((String)subjectType)) {
                selectedSubjectTypes = Arrays.stream(subjectType.split("_")).map(ii -> {
                    try {
                        return Integer.parseInt(ii);
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }).filter(ii -> ii != null).collect(Collectors.toList());
            }
            Integer page = params.getParameterAsInteger("_currpage");
            Integer lines = params.getParameterAsInteger("_rowcount");
            if (page == null || page <= 0) {
                page = 1;
            }
            if (lines == null || lines <= 0) {
                lines = 30;
            }
            WebUser user = this.getUser();
            DataPackage<Notice> data = this.noticeProcess.queryNoticeByCondition(summary, isRead, selectedSubjectTypes, page, lines, user.getId());
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/modules"})
    @ApiOperation(value="\u83b7\u53d6\u6d88\u606f\u7684\u6a21\u5757\u5185\u5bb9", notes="\u83b7\u53d6\u6d88\u606f\u7684\u6a21\u5757\u5185\u5bb9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="readStatus", value="\u9605\u8bfb\u72b6\u6001", required=true, paramType="query", dataType="int"), @ApiImplicitParam(name="_currpage", value="\u9875\u957f\u5ea6", required=false, paramType="query", dataType="string", defaultValue="1"), @ApiImplicitParam(name="_rowcount", value="\u5f53\u524d\u9875\u7801", required=false, paramType="query", dataType="string", defaultValue="10"), @ApiImplicitParam(name="type", value="\u540e\u7eed\u8865\u5145", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doModuleQuery() {
        try {
            ParamsTable params = this.getParams();
            String summary = params.getParameterAsString("summary");
            Boolean isRead = null;
            String readStatus = params.getParameterAsString("readStatus");
            if (!StringUtil.isBlank((String)readStatus)) {
                isRead = "0".equals(readStatus) ? Boolean.valueOf(false) : Boolean.valueOf(true);
            }
            WebUser user = this.getUser();
            List<Map<String, Object>> data = this.noticeProcess.queryModuleNoticeByCondition(summary, isRead, user.getId());
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u4e8b\u9879\u63d0\u9192\u901a\u77e5", notes="\u5220\u9664\u4e8b\u9879\u63d0\u9192\u901a\u77e5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="noticeId", value="\u901a\u77e5\u4e8b\u9879id", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doDelete(@RequestParam String noticeId) {
        try {
            this.noticeProcess.doRemove(noticeId);
            return this.addActionResult(true, "", null);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @PostMapping
    public void doCreate(@RequestBody Notice notice) {
        try {
            notice.setId(this.snowflake.nextIdStr());
            this.noticeProcess.doCreate(notice);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u521b\u5efa\u6d88\u606f\u5f02\u5e38\uff0c\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\uff1a{}", new Object[]{JSONObject.toJSONString((Object)notice), e.getMessage(), e});
            throw new SaasBadException("\u521b\u5efa\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    @PostMapping(value={"/create/list"})
    public void doCreateList(@RequestBody List<Notice> voList) {
        try {
            if (CollectionUtil.isNotEmpty(voList)) {
                voList.forEach(notice -> notice.setId(this.snowflake.nextIdStr()));
                this.noticeProcess.doCreateList(voList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6279\u91cf\u521b\u5efa\u6d88\u606f\uff0c\u53c2\u6570\uff1a{}\uff0c\u9519\u8bef\uff1a{}", new Object[]{JSONObject.toJSONString(voList), e.getMessage(), e});
            throw new SaasBadException("\u6279\u91cf\u521b\u5efa\u6d88\u606f\u5f02\u5e38", e);
        }
    }

    @Deprecated
    @PutMapping(value={"/read"})
    @ApiOperation(value="\u8bbe\u7f6e\u4e8b\u9879\u63d0\u9192\u901a\u77e5\u4e3a\u5df2\u8bfb", notes="\u8bbe\u7f6e\u4e8b\u9879\u63d0\u9192\u901a\u77e5\u4e3a\u5df2\u8bfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="noticeId", value="\u901a\u77e5\u4e8b\u9879id", required=true, paramType="query", dataType="string")})
    public Map<String, Object> set2Read(@RequestParam String noticeId) {
        try {
            this.noticeProcess.setNotice2Read(noticeId);
            return this.addActionResult(true, "", null);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @PutMapping(value={"/allRead"})
    @ApiOperation(value="\u6807\u8bb0\u6240\u6709\u672a\u8bfb\u901a\u77e5\u4e3a\u5df2\u8bfb", notes="\u6807\u8bb0\u6240\u6709\u672a\u8bfb\u901a\u77e5\u4e3a\u5df2\u8bfb")
    public Map<String, Object> markAllAsRead() {
        try {
            this.noticeProcess.markAllAsRead(this.getUser().getId());
            return this.addActionResult(true, "", null);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }
}

