/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.message.service;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.auth.IUser;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.common.util.StringUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.UserAPI;
import cn.myapps.message.message.dao.MessageDAO;
import cn.myapps.message.message.model.Message;
import cn.myapps.message.message.service.MessageProcess;
import cn.myapps.message.notification.service.NotificationProcess;
import cn.myapps.message.util.sequence.Sequence;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MessageProcessBean
implements MessageProcess {
    @Autowired
    private MessageDAO messageDAO;
    @Autowired(required=false)
    private NotificationProcess notificationProcess;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Message doSaveMessage(ParamsTable params, Message vo, IUser user) throws Exception {
        return null;
    }

    @Override
    public Message doPublicMessage(ParamsTable params, Message vo, IUser user) throws Exception {
        Message message;
        block17: {
            message = vo;
            try {
                String applicationId = params.getParameterAsString("application");
                String domainId = user.getDomainid();
                String info = params.getParameterAsString("receiverInfo");
                HashSet<String> receiverId = null;
                HashSet<String> receiverDeptId = null;
                if (vo == null) break block17;
                if (StringUtil.isBlank((String)vo.getId())) {
                    vo.setId(Sequence.getSequence());
                }
                vo.setCreateTime(new Date());
                vo.setSender(user.getName());
                vo.setSenderId(user.getId());
                String defaultDepartmentId = user.getDefaultDepartment();
                JSONObject department = this.getDepartmentById(defaultDepartmentId);
                vo.setSenderDept((String)department.get("name"));
                vo.setSenderDeptId((String)department.get("id"));
                vo.setComment(true);
                vo.setSticky(false);
                vo.setReceiverInfo(info);
                vo.setDomainid(domainId);
                if (vo.getScope() != 0) {
                    if (vo.getScope() == 2) {
                        String deptId;
                        JSONObject receiverInfo = JSONObject.fromObject((Object)info);
                        JSONArray users = receiverInfo.getJSONArray("user");
                        JSONArray depts = receiverInfo.getJSONArray("dept");
                        if (!users.isEmpty()) {
                            if (receiverId == null) {
                                receiverId = new HashSet<String>();
                                receiverDeptId = new HashSet<String>();
                            }
                            for (int index = 0; index < users.size(); ++index) {
                                JSONObject Juser = users.getJSONObject(index);
                                String userId = Juser.getString("userId");
                                deptId = Juser.getString("deptId");
                                if (StringUtil.isBlank((String)userId) || receiverId.contains(userId)) continue;
                                receiverId.add(userId);
                                receiverDeptId.add(deptId);
                            }
                        }
                        if (!depts.isEmpty()) {
                            if (receiverId == null) {
                                receiverId = new HashSet();
                                receiverDeptId = new HashSet();
                            }
                            JSONObject rootDepartment = this.getRootDepartment();
                            for (int index = 0; index < depts.size(); ++index) {
                                JSONObject Jdept = depts.getJSONObject(index);
                                deptId = Jdept.getString("deptId");
                                String rootid = (String)rootDepartment.get("id");
                                if (!rootid.equals(deptId)) {
                                    JSONArray array = this.getUsersByDepartment(deptId);
                                    if (array.isEmpty()) continue;
                                    for (Object obj : array) {
                                        JSONObject json = JSONObject.fromObject(obj);
                                        String id = (String)json.get("id");
                                        if (receiverId.contains(id)) continue;
                                        receiverId.add(id);
                                        receiverDeptId.add(deptId);
                                    }
                                    continue;
                                }
                                receiverId.clear();
                                receiverDeptId.clear();
                                message.setScope(0);
                                break;
                            }
                        }
                        String _receiverId = null;
                        String _receiverDeptId = null;
                        if (!receiverId.isEmpty()) {
                            _receiverId = receiverId.toString().substring(1, receiverId.toString().length() - 1);
                            _receiverDeptId = receiverDeptId.toString().substring(1, receiverDeptId.toString().length() - 1);
                        } else {
                            _receiverId = "";
                            _receiverDeptId = "";
                        }
                        vo.setReceiverId(_receiverId);
                        vo.setReceiverDeptId(_receiverDeptId);
                    } else if (vo.getScope() == 1) {
                        // empty if block
                    }
                }
                message = (Message)this.messageDAO.save(vo);
                this.createNotification4PersonalMessage(message, domainId, user);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        return message;
    }

    @Override
    public Message doPublicAnnouncement(ParamsTable params, Message vo, IUser user) throws Exception {
        Message message;
        block19: {
            message = vo;
            String applicationId = params.getParameterAsString("application");
            String domainId = user.getDomainid();
            HashSet<String> receiverId = null;
            HashSet<String> receiverDeptId = null;
            if (vo == null) break block19;
            if (StringUtil.isBlank((String)vo.getId())) {
                vo.setId(Sequence.getSequence());
            }
            vo.setCreateTime(new Date());
            vo.setSender(user.getName());
            vo.setSenderId(user.getId());
            String defaultDepartmentId = user.getDefaultDepartment();
            JSONObject department = this.getDepartmentById(defaultDepartmentId);
            vo.setSenderDept((String)department.get("name"));
            vo.setSenderDeptId((String)department.get("id"));
            vo.setDomainid(domainId);
            if (vo.getScope() != 0) {
                if (vo.getScope() == 2) {
                    String deptId;
                    String info = params.getParameterAsString("receiverInfo");
                    JSONObject receiverInfo = JSONObject.fromObject((Object)info);
                    JSONArray users = receiverInfo.getJSONArray("user");
                    JSONArray depts = receiverInfo.getJSONArray("dept");
                    if (!users.isEmpty()) {
                        if (receiverId == null) {
                            receiverId = new HashSet<String>();
                            receiverDeptId = new HashSet<String>();
                        }
                        for (int index = 0; index < users.size(); ++index) {
                            JSONObject Juser = users.getJSONObject(index);
                            String userId = Juser.getString("userId");
                            deptId = Juser.getString("deptId");
                            if (StringUtil.isBlank((String)userId) || receiverId.contains(userId)) continue;
                            receiverId.add(userId);
                            receiverDeptId.add(deptId);
                        }
                    }
                    if (!depts.isEmpty()) {
                        if (receiverId == null) {
                            receiverId = new HashSet();
                            receiverDeptId = new HashSet();
                        }
                        JSONObject rootDepartment = this.getRootDepartment();
                        for (int index = 0; index < depts.size(); ++index) {
                            JSONObject Jdept = depts.getJSONObject(index);
                            deptId = Jdept.getString("deptId");
                            String rootid = (String)rootDepartment.get("id");
                            if (!rootid.equals(deptId)) {
                                JSONArray array = this.getUsersByDepartment(deptId);
                                if (array.isEmpty()) continue;
                                for (Object obj : array) {
                                    JSONObject json = JSONObject.fromObject(obj);
                                    String id = (String)json.get("id");
                                    if (receiverId.contains(id)) continue;
                                    receiverId.add(id);
                                    receiverDeptId.add(deptId);
                                }
                                continue;
                            }
                            receiverId.clear();
                            receiverDeptId.clear();
                            message.setScope(0);
                            break;
                        }
                    }
                    String _receiverId = null;
                    String _receiverDeptId = null;
                    if (!receiverId.isEmpty()) {
                        _receiverId = ((Object)receiverId).toString().substring(1, ((Object)receiverId).toString().length() - 1);
                        _receiverDeptId = ((Object)receiverDeptId).toString().substring(1, ((Object)receiverDeptId).toString().length() - 1);
                    } else {
                        _receiverId = "";
                        _receiverDeptId = "";
                    }
                    vo.setReceiverId(_receiverId);
                    vo.setReceiverDeptId(_receiverDeptId);
                } else if (vo.getScope() == 1) {
                    // empty if block
                }
            }
            message = (Message)this.messageDAO.save(vo);
            try {
                this.notificationProcess.doCreateMessagesNotification(message, domainId, user);
            }
            catch (Exception exception) {}
        }
        return message;
    }

    @Override
    public DataPackage<Message> queryMessages(String content, int page, int lines, IUser user) throws Exception {
        this.entityManager.clear();
        DataPackage data = new DataPackage();
        data.setPageNo(page);
        data.setLinesPerPage(lines);
        String condition = "";
        if (!StringUtil.isBlank((String)content)) {
            condition = condition + " AND (me.CONTENT like '" + content + "%' OR me.SENDER like '" + content + "%' OR me.title like '" + content + "%')";
        }
        String sql = "SELECT * FROM MC_MESSAGE me WHERE ? IN (me.SENDER_ID,me.RECEIVER_ID) " + condition;
        String countSql = "SELECT COUNT(*) FROM (" + sql + ") as xt";
        sql = "select * from (" + sql + ") AS TB ORDER BY CREATE_TIME desc";
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        boolean index = true;
        map.put(1, user.getId());
        Query query = this.entityManager.createNativeQuery(sql, Message.class);
        Query countQuery = this.entityManager.createNativeQuery(countSql);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            query.setParameter(key, map.get(key));
            countQuery.setParameter(key, map.get(key));
        }
        query.setFirstResult((page - 1) * lines);
        query.setMaxResults(lines);
        long total = ((BigInteger)countQuery.getSingleResult()).longValue();
        List list = query.getResultList();
        data.setRowCount((int)total);
        data.setDatas((Collection)list);
        return data;
    }

    @Override
    public DataPackage<Message> queryMessagesISend(String content, int page, int lines, IUser user) throws Exception {
        return null;
    }

    @Override
    public DataPackage<Message> queryMessage4Announcement(String content, int page, int lines, IUser user) throws Exception {
        this.entityManager.clear();
        DataPackage data = new DataPackage();
        data.setPageNo(page);
        data.setLinesPerPage(lines);
        String sql = "SELECT * FROM MC_MESSAGE me WHERE me.DOMAIN_ID=? AND ? IN (me.SENDER_ID,me.RECEIVER_ID)";
        String countSql = "SELECT COUNT(*) FROM  MC_MESSAGE me WHERE me.DOMAIN_ID=? AND ? IN (me.SENDER_ID,me.RECEIVER_ID)";
        sql = sql + "AND me.TYPE = 1";
        countSql = countSql + "AND me.TYPE = 1";
        if (!StringUtil.isBlank((String)content)) {
            sql = sql + " AND (me.CONTENT like '%" + content + "%' OR me.SENDER like '%" + content + "%' OR me.title like '%" + content + "%')";
            countSql = countSql + " AND (me.CONTENT like '%" + content + "%' OR me.SENDER like '%" + content + "%' OR me.title like '%" + content + "%')";
        }
        sql = "select * from (" + sql + ") AS TB ORDER BY IS_STICKY desc,CREATE_TIME desc";
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        boolean index = true;
        map.put(1, user.getDomainid());
        map.put(2, user.getId());
        Query query = this.entityManager.createNativeQuery(sql, Message.class);
        Query countQuery = this.entityManager.createNativeQuery(countSql);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            query.setParameter(key, map.get(key));
            countQuery.setParameter(key, map.get(key));
        }
        query.setFirstResult((page - 1) * lines);
        query.setMaxResults(lines);
        long total = ((BigInteger)countQuery.getSingleResult()).longValue();
        List list = query.getResultList();
        data.setRowCount((int)total);
        data.setDatas((Collection)list);
        return data;
    }

    @Override
    public DataPackage<Message> queryMessage4Department(String content, Integer page, Integer lines, IUser user) throws Exception {
        return null;
    }

    @Override
    public void doDeleteMessageAndNotification(String messageId, String applicationId) throws Exception {
        try {
            this.messageDAO.deleteById(messageId);
            try {
                this.notificationProcess.doRemove(messageId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void doCancelMessageTop(String messageId, IUser user) throws Exception {
    }

    @Override
    public void doCreateMessage(String receiverid, String title, String content, String userId) throws Exception {
        Message message = new Message();
        try {
            WebUser user = this.getUserById(userId);
            this.setBasicProperties4PersonMessage(message, content, title, user);
            message.setReceiverId(receiverid);
            message = (Message)this.messageDAO.save(message);
            this.createNotification4PersonalMessage(message, user.getDomainid(), user);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void doCreateMessageByDept(String departmentid, String title, String content, String userId) throws Exception {
    }

    @Override
    public void doCreateMessageByRole(String roleid, String title, String content, String userId) throws Exception {
    }

    @Override
    public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
        return null;
    }

    @Override
    public Message doView(String pk) throws Exception {
        return (Message)this.messageDAO.findById(pk).get();
    }

    @Override
    public void doRemove(String pk) throws Exception {
    }

    @Override
    public void doRemove(String[] pk) throws Exception {
    }

    @Override
    public DataPackage<Message> doQuery(ParamsTable params, IUser user) throws Exception {
        return null;
    }

    private JSONObject getDepartmentById(String departmentId) {
        UserAPI departmentAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
        Resource departmentUsers = departmentAPI.getAllDepartmentUsers();
        JSONArray array = JSONArray.fromObject((Object)departmentUsers.getData());
        for (Object obj : array) {
            JSONObject json = JSONObject.fromObject(obj);
            if (!departmentId.equals(json.get("id"))) continue;
            return json;
        }
        return new JSONObject();
    }

    private JSONObject getRootDepartment() {
        UserAPI departmentAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
        Resource departmentUsers = departmentAPI.getAllDepartmentUsers();
        JSONArray array = JSONArray.fromObject((Object)departmentUsers.getData());
        for (Object obj : array) {
            JSONObject json = JSONObject.fromObject(obj);
            int level = (Integer)json.get("level");
            if (0 != level) continue;
            return json;
        }
        return new JSONObject();
    }

    private JSONArray getUsersByDepartment(String deptid) {
        UserAPI userAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
        Collection departmentUsers = userAPI.getDepartmentUsers(deptid);
        JSONArray array = JSONArray.fromObject((Object)departmentUsers);
        return array;
    }

    private JSONArray getUsersByDomian(String domainid) {
        UserAPI userAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
        Collection departmentUsers = userAPI.getDomainUsers(domainid);
        JSONArray array = JSONArray.fromObject((Object)departmentUsers);
        return array;
    }

    private WebUser getUserById(String userId) throws Exception {
        WebUser user = new WebUser();
        UserAPI userAPI = (UserAPI)SpringApplicationContextUtil.getBean(UserAPI.class);
        Map userMap = new LinkedHashMap();
        FeignConfig.ACCESS_TOKEN = Security.getToken((String)userId);
        userMap = (Map)userAPI.getUserById(userId).getData();
        user.setId(userId);
        user.setName((String)userMap.get("name"));
        user.setDomainid((String)userMap.get("domainId"));
        user.setDefaultDepartment((String)userMap.get("deptId"));
        return user;
    }

    private void createNotification4PersonalMessage(Message message, String domainId, IUser user) {
        try {
            this.notificationProcess.doCreateNotification4PerssonalMessage(message, domainId, user);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setBasicProperties4PersonMessage(Message msg, String content, String title, IUser user) throws Exception {
        if (StringUtil.isBlank((String)msg.getId())) {
            msg.setId(Sequence.getSequence());
        }
        String defaultDepartmentId = user.getDefaultDepartment();
        msg.setCreateTime(new Date());
        msg.setSender(user.getName());
        msg.setSenderId(user.getId());
        JSONObject department = this.getDepartmentById(defaultDepartmentId);
        msg.setSenderDept((String)department.get("name"));
        msg.setSenderDeptId((String)department.get("id"));
        msg.setDomainid(user.getDomainid());
        msg.setComment(true);
        msg.setSticky(false);
        msg.setTitle(title);
        msg.setContent(content);
        msg.setType(0);
        msg.setScope(2);
    }
}

