/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.comment.controller;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.message.base.controller.BaseController;
import cn.myapps.message.comment.model.Comment;
import cn.myapps.message.comment.service.CommentProcess;
import cn.myapps.message.comment.service.CommentProcessBean;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/api/message/comment"})
@Scope(value="prototype")
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@Api(tags={"\u8bc4\u8bba\u6a21\u5757"})
public class CommentController
extends BaseController<Comment> {
    @Autowired
    private CommentProcess commentProcess;

    public CommentController() {
        this.content = new Comment();
        this.process = new CommentProcessBean();
    }

    @PostMapping
    @ApiOperation(value="\u53d1\u8868\u8bc4\u8bba", notes="\u53d1\u8868\u8bc4\u8bba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string")})
    public Map<String, Object> doComment() {
        try {
            WebUser user = this.getUser();
            Comment content = (Comment)this.getContent();
            ParamsTable params = this.getParams();
            content.setToUser(params.getParameterAsString("content.toUser"));
            content.setToUserId(params.getParameterAsString("content.toUserId"));
            content.setMessageId(params.getParameterAsString("content.messageId"));
            content.setContent(params.getParameterAsString("content.content"));
            content = this.commentProcess.doComment(params, content, user);
            return this.addActionResult(true, "\u53d1\u5e03\u6210\u529f", content);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u8bc4\u8bba", notes="\u5220\u9664\u8bc4\u8bba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="commentId", value="\u8bc4\u8bbaid", required=true, paramType="query", dataType="string"), @ApiImplicitParam(name="messageId", value="\u4fe1\u606fid", required=true, paramType="query", dataType="string")})
    public Map<String, Object> doDelete(@RequestParam String commentId, @RequestParam String messageId) {
        try {
            WebUser user = this.getUser();
            ParamsTable params = this.getParams();
            String domainId = user.getDomainid();
            this.commentProcess.doDeleteCommon(commentId, messageId, domainId);
            return this.addActionResult(true, "\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/my/reply"})
    @ApiOperation(value="\u6211\u56de\u590d\u7684\u8bc4\u8bba", notes="\u6211\u56de\u590d\u7684\u8bc4\u8bba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="_currpage", value="\u9875\u957f\u5ea6", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="_rowcount", value="\u5f53\u524d\u9875\u7801", required=false, paramType="query", dataType="string")})
    public Map<String, Object> doQueryIReply() {
        try {
            ParamsTable params = this.getParams();
            String content = params.getParameterAsString("content");
            Integer page = params.getParameterAsInteger("_currpage");
            Integer lines = params.getParameterAsInteger("_rowcount");
            if (page == null || page <= 0) {
                page = 1;
            }
            if (lines == null || lines <= 0) {
                lines = 30;
            }
            WebUser user = this.getUser();
            DataPackage<Comment> data = this.commentProcess.queryCommentIReply(content, page, lines, user);
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping(value={"/my/receive"})
    @ApiOperation(value="\u56de\u590d\u6211\u7684\u8bc4\u8bba", notes="\u56de\u590d\u6211\u7684\u8bc4\u8bba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="_currpage", value="\u9875\u957f\u5ea6", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="_rowcount", value="\u5f53\u524d\u9875\u7801", required=false, paramType="query", dataType="string")})
    public Map<String, Object> doQueryIReceive() {
        try {
            ParamsTable params = this.getParams();
            String content = params.getParameterAsString("content");
            Integer page = params.getParameterAsInteger("_currpage");
            Integer lines = params.getParameterAsInteger("_rowcount");
            if (page == null || page <= 0) {
                page = 1;
            }
            if (lines == null || lines <= 0) {
                lines = 30;
            }
            WebUser user = this.getUser();
            DataPackage<Comment> data = this.commentProcess.queryCommentIReceive(content, page, lines, user);
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }

    @GetMapping
    @ApiOperation(value="\u6d88\u606f\u4e0b\u7684\u8bc4\u8bba\u5217\u8868", notes="\u6d88\u606f\u4e0b\u7684\u8bc4\u8bba\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="content", value="\u8bf7\u6c42\u5305\u4f53", required=true, paramType="body", dataType="string"), @ApiImplicitParam(name="_currpage", value="\u9875\u957f\u5ea6", required=false, paramType="query", dataType="string"), @ApiImplicitParam(name="_rowcount", value="\u5f53\u524d\u9875\u7801", required=false, paramType="query", dataType="string")})
    public Map<String, Object> doQuery() {
        try {
            ParamsTable params = this.getParams();
            String messageId = params.getParameterAsString("messageId");
            Integer page = params.getParameterAsInteger("_currpage");
            Integer lines = params.getParameterAsInteger("_rowcount");
            if (page == null || page <= 0) {
                page = 1;
            }
            if (lines == null || lines <= 0) {
                lines = 30;
            }
            WebUser user = this.getUser();
            DataPackage<Comment> data = this.commentProcess.queryComments4Message(messageId, page, lines, user);
            return this.addActionResult(true, "", data);
        }
        catch (Exception e) {
            if (!(e instanceof OBPMValidateException)) {
                e.printStackTrace();
            }
            return this.addActionResult(false, e.getMessage(), null);
        }
    }
}

