/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.base.service;

import cn.myapps.common.auth.IUser;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.model.AuthtimeValueObject;
import cn.myapps.common.util.StringUtil;
import cn.myapps.message.base.dao.BaseDAO;
import cn.myapps.message.base.service.BaseProcess;
import cn.myapps.message.util.ConnectionManager;
import cn.myapps.message.util.sequence.Sequence;
import java.sql.Connection;

public abstract class AbstractBaseProcessBean<E>
implements BaseProcess<E> {
    public static final ThreadLocal<Integer> transactionSignal = new ThreadLocal();

    public abstract BaseDAO getDAO() throws Exception;

    protected Connection getConnection() throws Exception {
        return ConnectionManager.getConnection();
    }

    public void beginTransaction() throws Exception {
        int signal = this.getTransactionSignal();
        if (signal == 0) {
            Connection conn = this.getConnection();
            conn.setAutoCommit(false);
            String driverName = conn.getMetaData().getDriverName();
            if (!driverName.equals("Oracle JDBC driver") && !driverName.equals("dm.jdbc.driver.DmDriver")) {
                conn.setTransactionIsolation(1);
            }
        }
        this.setTransactionSignal(++signal);
    }

    public void commitTransaction() throws Exception {
        int signal = this.getTransactionSignal();
        if (--signal == 0) {
            Connection conn = this.getConnection();
            conn.commit();
            conn.setAutoCommit(true);
            String driverName = conn.getMetaData().getDriverName();
            if (!driverName.equals("Oracle JDBC driver") && !driverName.equals("dm.jdbc.driver.DmDriver")) {
                conn.setTransactionIsolation(2);
            }
        }
        this.setTransactionSignal(signal);
    }

    public void rollbackTransaction() throws Exception {
        int signal = this.getTransactionSignal();
        if (--signal == 0) {
            Connection conn = this.getConnection();
            conn.rollback();
            conn.setAutoCommit(true);
            String driverName = conn.getMetaData().getDriverName();
            if (!driverName.equals("Oracle JDBC driver") && !driverName.equals("dm.jdbc.driver.DmDriver")) {
                conn.setTransactionIsolation(2);
            }
        }
        this.setTransactionSignal(signal);
    }

    protected int getTransactionSignal() {
        Integer signal = transactionSignal.get();
        if (signal != null) {
            return signal;
        }
        return 0;
    }

    protected void setTransactionSignal(int signal) {
        transactionSignal.set(signal);
    }

    @Override
    public AuthtimeValueObject doCreate(AuthtimeValueObject vo) throws Exception {
        try {
            this.beginTransaction();
            if (StringUtil.isBlank((String)vo.getId())) {
                vo.setId(Sequence.getSequence());
            }
            vo = this.getDAO().create(vo);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            e.printStackTrace();
            throw e;
        }
        return vo;
    }

    @Override
    public DataPackage<E> doQuery(ParamsTable params, IUser user) throws Exception {
        return null;
    }

    @Override
    public void doRemove(String pk) throws Exception {
        try {
            this.beginTransaction();
            this.getDAO().remove(pk);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public void doRemove(String[] pks) throws Exception {
        try {
            this.beginTransaction();
            for (String pk : pks) {
                this.doRemove(pk);
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public AuthtimeValueObject doUpdate(AuthtimeValueObject vo) throws Exception {
        try {
            this.beginTransaction();
            vo = this.getDAO().update(vo);
            this.commitTransaction();
        }
        catch (Exception e) {
            this.rollbackTransaction();
            e.printStackTrace();
            throw e;
        }
        return vo;
    }

    @Override
    public AuthtimeValueObject doView(String pk) throws Exception {
        return this.getDAO().find(pk);
    }
}

