/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps.message.base.dao;

import cn.myapps.message.util.ConnectionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseDAO {
    private static final Logger log = LoggerFactory.getLogger(AbstractBaseDAO.class);
    protected String dbTag = "MS SQL SERVER: ";
    protected String schema = "";
    protected String tableName = "";
    protected Connection connection;

    public AbstractBaseDAO(Connection conn) throws Exception {
        this.connection = conn;
    }

    protected abstract String buildLimitString(String var1, int var2, int var3, String var4, String var5) throws SQLException;

    public String getFullTableName(String tblname) {
        if (this.schema != null && !this.schema.trim().equals("")) {
            return this.schema.trim().toUpperCase() + "." + tblname.trim().toUpperCase();
        }
        return tblname.trim().toUpperCase();
    }

    public void update(Map<String, Object> items, String pk) throws Exception {
        PreparedStatement stmt = null;
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(this.getFullTableName(this.tableName)).append(" SET ");
        Set<String> keys = items.keySet();
        for (String key : keys) {
            sql.append(key).append("=?,");
        }
        sql.setLength(sql.length() - 1);
        sql.append(" WHERE ID=?");
        log.debug("{}", (Object)sql);
        try {
            stmt = this.connection.prepareStatement(sql.toString());
            int index = 1;
            for (String key : keys) {
                Object value = items.get(key);
                if (value instanceof Date) {
                    Timestamp ts = new Timestamp(((Date)value).getTime());
                    stmt.setTimestamp(index, ts);
                } else {
                    stmt.setObject(index, value);
                }
                ++index;
            }
            stmt.setString(index, pk);
            stmt.execute();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionManager.closeStatement(stmt);
                throw throwable;
            }
        }
        ConnectionManager.closeStatement(stmt);
    }
}

