/*
 * Decompiled with CFR 0.152.
 */
package cn.myapps;

import cn.myapps.base.web.WebUser;
import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import com.jayway.jsonpath.PathNotFoundException;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

@RestController
public abstract class AbstractRuntimeController {
    @Autowired
    protected HttpServletRequest request;
    @Autowired
    protected HttpSession session;
    private String domain;
    private Resource resourceValue;

    protected WebUser getUser() throws Exception {
        WebUser user = new WebUser();
        String userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
        user.setId(userId);
        return user;
    }

    protected String getUserId() throws Exception {
        String userId = null;
        try {
            userId = Security.getUserIdFromToken((HttpServletRequest)this.request);
            if (userId == null) {
                userId = Security.getDebugUserIdFromToken((HttpServletRequest)this.request);
            }
        }
        catch (Exception e) {
            return null;
        }
        return userId;
    }

    public ParamsTable getParams() {
        String isRelate;
        String parentid;
        String parentId;
        ParamsTable pm = ParamsTable.convertHTTP((HttpServletRequest)this.request);
        if (pm.getParameter("_pagelines") == null) {
            pm.setParameter("_pagelines", (Object)10);
        }
        if (!StringUtil.isBlank((String)(parentId = pm.getParameterAsString("parentId")))) {
            pm.setParameter("relateid", (Object)parentId);
            pm.setParameter("parentid", (Object)parentId);
        }
        if (!StringUtil.isBlank((String)(parentid = pm.getParameterAsString("parentid")))) {
            pm.setParameter("relateid", (Object)parentid);
            pm.setParameter("parentId", (Object)parentid);
        }
        if (StringUtil.isBlank((String)(isRelate = pm.getParameterAsString("isRelate"))) || !"true".equals(isRelate)) {
            pm.removeParameter("parentId");
            pm.removeParameter("parentid");
        }
        return pm;
    }

    protected Resource success(String errmsg, Object data) {
        return new Resource(0, errmsg, data, null);
    }

    protected Resource successWithPagination(String errmsg, Object data, int page, int page_lines, int row_count) {
        JSONObject json = new JSONObject();
        json.put((Object)"data", data);
        json.put((Object)"page", (Object)page);
        json.put((Object)"page_lines", (Object)page_lines);
        json.put((Object)"row_count", (Object)row_count);
        this.resourceValue = new Resource(0, errmsg, (Object)json, null);
        return this.resourceValue;
    }

    protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
        return new Resource(errcode, errmsg, null, errors);
    }

    public Resource getResourceValue() {
        return this.resourceValue;
    }

    public void setResourceValue(Resource resourceValue) {
        this.resourceValue = resourceValue;
    }

    @ExceptionHandler(value={ResourceNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Resource resourceNotFound(ResourceNotFoundException e) {
        return this.error(404, "Not Found", null);
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource error(RuntimeException e) {
        e.printStackTrace();
        return this.error(500, "Server Error", null);
    }

    @ExceptionHandler(value={OBPMValidateException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public Resource serverError(OBPMValidateException e) {
        e.printStackTrace();
        return this.error(500, "Server Error", null);
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
        return this.error(40035, "\u4e0d\u5408\u6cd5\u7684\u53c2\u6570", null);
    }

    @ExceptionHandler(value={PathNotFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_ACCEPTABLE)
    public Resource requestbodyError(PathNotFoundException e) {
        e.printStackTrace();
        return this.error(406, "\u8bf7\u6c42\u5305\u4f53\u53c2\u6570\u51fa\u9519", null);
    }
}

