package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication
//@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
//@SpringBootApplication
@EnableFeignClients(basePackages = "cn.myapps.conf")
@ComponentScan(basePackages = { "cn.myapps.conf", "cn.myapps.common.util",
		// "cn.myapps.runtime.rest.security.service",
		//"cn.myapps.util",
		//"cn.myapps.base.web",
		//"cn.myapps.runtime.common.utils",
		"cn.myapps.message",
		"cn.myapps.**.message.controller",
		"cn.myapps.message.notice.service",
		"cn.myapps.**.message.dao",
		"cn.myapps.message.**.dao",
		"cn.myapps.**.message.service",
		//"cn.myapps.**.action",
		//"com.teemlink.km",
		//"cn.myapps.common.exception",
		"cn.myapps.message.**.controller",
		"cn.myapps.message.**.service"
		//,
		//, "cn.myapps.designtime.report"
//		"cn.myapps.runtime.workflow.analyzer"
//		, "com.jgqz"
		})
@EntityScan(basePackages= {"cn.myapps.message"})
@EnableJpaRepositories(basePackages= {"cn.myapps.message.**.dao"})
@EnableDiscoveryClient
public class MessageApp {

	public static void main(String[] args) {
		SpringApplication.run(MessageApp.class, args);
	}

}
