package com.teemlink.email.util;

import cn.myapps.common.util.PropertyUtil;

import org.springframework.beans.factory.annotation.Value;

import java.io.Serializable;


/**
 * The environment variable.
 */
public class Environment implements Serializable{

	/**
	 *
	 */
	private static final long serialVersionUID = 7874636871392290110L;

	private String _wcpath;

	private String _contextPath;

	private String encoding = "UTF-8";

	private String baseUrl;

	@Value("${server.context-path:/}")
	private String contextPath;


	/**
	 * 应用软件模板workspace在文件系统中的目录位置
	 */
	private String workspaceRootPath = null;
	/**
	 * @return the encoding
	 */
	public String getEncoding() {
		return encoding;
	}

	/**
	 * @param encoding
	 *            the encoding to set
	 */
	public void setEncoding(String encoding) {
		this.encoding = encoding;
	}

	private static Environment env = null;


	public static Environment getInstance() {
		if (env == null) {
			env = new Environment();
		}

		return env;
	}

	private Environment() {
		super();
		this.setContextPath(contextPath);
		String  workRootPath  =  PropertyUtil.getPath()+"/workspace";
		this.workspaceRootPath = workRootPath;
		this._wcpath = PropertyUtil.getPath();
	}

	/**
	 * @param wcpath
	 *            The web context path.
	 */
	public void setApplicationRealPath(String wcpath) {
		_wcpath = wcpath;
	}

	/**
	 * Retrieve the web context path.
	 *
	 * @return The web context path.
	 */
	public String getApplicationRealPath() {
		return (_wcpath != null) ? _wcpath : "";
	}

	/**
	 * Retrieve the web context physicsal path.
	 *
	 * @param path
	 *            The web path.
	 * @return The web context physicsal path.
	 */
	public String getRealPath(String path) {
		String realpath = (path != null) ? getApplicationRealPath() + path : "";
		realpath = realpath.replaceAll("\\\\", "/");

		return realpath;
	}

	/**
	 * Set request context path;
	 *
	 * @param cpath
	 * @return
	 */
	public String setContextPath(String cpath) {
		return _contextPath = cpath;
	}

	public String getContextPath() {
		return _contextPath != null ? _contextPath : "/";
	}

	public String getContext(String uri) {
		if (_contextPath.equals("/")) {
			return uri;
		} else {
			return _contextPath + uri;
		}
	}

	public String getBaseUrl() {
		return baseUrl;
	}

	public void setBaseUrl(String baseUrl) {
		this.baseUrl = baseUrl;
	}


}
