package com.teemlink.email.runtime.mail;

import java.util.*;

import javax.mail.*;

import cn.myapps.common.exception.OBPMValidateException;

import com.teemlink.email.util.Constants;
import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPStore;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.POP3Store;

public class ConnectionMetaHandler {

	/**
	 * 
	 */
	private static final long serialVersionUID = -5420747046218417670L;
	private Folder folder;
	private Store store;
	private Map<Long, Folder> systemFolders;
	private Map<Long, Folder> otherFolders;

	public ConnectionMetaHandler() {
		systemFolders = new HashMap<Long, Folder>();
		otherFolders = new HashMap<Long, Folder>();
	}

	/**
	 * @return the folder
	 */
	public Folder getFolder() {
		return folder;
	}

	/**
	 * @param folder
	 *            the folder to set
	 */
	public void setFolder(Folder folder) {
		this.folder = folder;
	}

	/**
	 * @return the store
	 */
	public Store getStore() {
		return store;
	}

	/**
	 * @param store
	 *            the store to set
	 */
	public void setStore(Store store) {
		this.store = store;
	}

	public void closeFolder(boolean flag) throws MessagingException {
		if (folder != null && folder.isOpen()) {
			folder.close(flag);
		}
	}

	public void closeStore() throws MessagingException {
		if (store != null && store.isConnected()) {
			store.close();
		}
		if (systemFolders != null) {
			systemFolders.clear();
		}
		if (otherFolders != null) {
			otherFolders.clear();
		}
	}
	public static void main(String[] args) {
		ConnectionMetaHandler handler = new ConnectionMetaHandler();
		Properties props = new Properties();
		props.setProperty("mail.store.protocol", "pop3");
		props.setProperty("mail.pop3.auth.plain.disable", "true");
		props.setProperty("mail.pop3.host", "pop.exmail.qq.com");
		props.setProperty("mail.pop3.port", "995");
		props.setProperty("mail.debug", "true");
		props.setProperty("mail.pop3.ssl.enable", "true");
		Session session = Session.getDefaultInstance(props);
		try {
			handler.setStore(session.getStore("pop3"));
			handler.getStore().connect("gary@weioa365.com", "dhTRLBBnTm3gFk8L");
			Folder[] list = handler.getStore().getDefaultFolder().list();
			Folder f = handler.getStore().getFolder("INBOX");
			f.open(Folder.READ_WRITE);
			int inbox = f.getMessageCount();
			Message[] messages = f.getMessages();
			System.out.println("1111");
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
//		ConnectionMetaHandler handler = new ConnectionMetaHandler();
//		Properties props = new Properties();
//		props.setProperty("mail.store.protocol", "imap");
//		props.setProperty("mail.imap.auth.plain.disable", "true");
//		props.setProperty("mail.imap.host", "imap.exmail.qq.com");
//		props.setProperty("mail.imap.port", "993");
//		props.setProperty("mail.debug", "true");
//		props.setProperty("mail.imap.ssl.enable", "true");
//		Session session = Session.getDefaultInstance(props);
//		try {
//			handler.setStore(session.getStore("imap"));
//			handler.getStore().connect("gary@weioa365.com", "dhTRLBBnTm3gFk8L");
//			handler.getStore().getDefaultFolder().list();
//			System.out.println("1111");
//		} catch (Exception e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
	}


	protected void initFolders() throws Exception {
		if (store instanceof IMAPStore) { //IMAP协议
			IMAPFolder[] imapFolders = (IMAPFolder[]) store.getDefaultFolder().list();
			for (int i = 0; i < imapFolders.length; i++) {
				IMAPFolder folder = imapFolders[i];
				String name = folder.getFullName();
				folder.open(Folder.READ_ONLY);
				long hashCode = folder.getName().hashCode() * folder.getFullName().hashCode();
				if (Constants.isSystemFolder(name)) {
					if(!systemFolders.containsKey(hashCode)){
						systemFolders.put(hashCode, folder);
					}
				} else {
					if(!otherFolders.containsKey(hashCode)){
						otherFolders.put(hashCode, folder);
					}
				}
			}
		} else if(store instanceof POP3Store){
			Folder[] pop3Folders = store.getDefaultFolder().list();
			for (int i = 0; i < pop3Folders.length; i++) {
				POP3Folder folder = (POP3Folder) pop3Folders[i];
				String name = folder.getFullName();
				folder.open(Folder.READ_ONLY);
				long hashCode = folder.getName().hashCode() * folder.getFullName().hashCode();
				if (Constants.isSystemFolder(name)) {
					if(!systemFolders.containsKey(hashCode)){
						systemFolders.put(hashCode, folder);
					}
				} else {
					if(!otherFolders.containsKey(hashCode)){
						otherFolders.put(hashCode, folder);
					}
				}
			}
		}else{
			throw new OBPMValidateException("无法查找相应邮件接收协议");
		}
	}

	public Folder getFolderByUID(long uid) {
		Folder folder = systemFolders.get(uid);
		if (folder == null) {
			folder = otherFolders.get(uid);
		}
		return folder;
	}

	public void removeFolder(long key) {
		otherFolders.remove(key);
	}

	public Map<Long, Folder> getSystemFolders() throws Exception {
		return systemFolders;
	}

	public Map<Long, Folder> getOtherFolders() throws Exception {
		return otherFolders;
	}
	
	public void removeOtherFolder() {
		if (folder instanceof IMAPFolder) {
			try {
				otherFolders.remove(((IMAPFolder)folder).getUIDValidity());
			} catch (MessagingException e) {
				
			}
		}
	}
	
	public Folder getFolderByName(String name, String ownerid) {
		Map<Long, Folder> folders = null;
		if (Constants.SYSTEM_FOLDER_ID.equals(ownerid)) {
			folders = systemFolders;
		} else {
			folders = otherFolders;
		}
		if (folders != null) {
			Set<Map.Entry<Long, Folder>> entrys = folders.entrySet();
			for (Iterator<Map.Entry<Long, Folder>> it = entrys.iterator(); it
					.hasNext();) {
				Map.Entry<Long, Folder> entry = it.next();
				Folder folder =  entry.getValue();
				if (folder.getFullName().equals(name)) {
					return folder;
				}
			}
		}
		return null;
	}

}
