package com.teemlink.email.folder.service;

import java.util.Collection;

import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.EmailService;
import com.teemlink.email.folder.model.EmailFolder;

import cn.myapps.common.data.DataPackage;


public interface EmailFolderProcess extends EmailService<EmailFolder> {

	public void initCreatDefaultMailFolder() throws Exception;

	public EmailFolder getEmailFolderById(String folderid) throws Exception;

	public EmailFolder getEmailFolderByOwnerId(String folderName, String ownerId) throws Exception;

	/**
	 * 根据文件名称判断该文件是否已创建
	 * 
	 * @param folderName
	 * @param ownerid
	 * @return
	 */
	public boolean emailFolderIsCreate(String folderName, String ownerid) throws Exception;

	public void doCreateEmailFolderByName(String folderName, String ownerId)
			throws Exception;
	/**
	 * 获取系统文件夹
	 * */
	public Collection<EmailFolder> getSystemEmailFolders() throws Exception;
	
	public EmailFolder getSystemEmailFolderByName(String folderName) throws Exception;
	/**
	 * 获取个人文件夹
	 * @param user  
	 * @param params
	 * */
	public DataPackage<EmailFolder> getPersonalEmailFolders(EmailUser user,int page,int lines) throws Exception;

	public void doRemoveEmailFolder(EmailFolder folder, EmailUser user) throws Exception;
	
	public int getPersonalEmailFolderCount(String ownerid) throws Exception;
	
}
