package com.teemlink.email.email.service;

import java.util.Date;

import cn.myapps.common.util.SequenceGenerator;
import com.teemlink.email.email.dao.EmailUserRepository;
import com.teemlink.email.email.model.EmailUser;


import cn.myapps.common.exception.OBPMValidateException;
import com.teemlink.email.email.base.EmailValueObject;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;

public class EmailUserProcessBean extends AbstractEmailServiceImpl<EmailUser> implements
		EmailUserProcess {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8921925024606594233L;
	@Autowired
	private EmailUserRepository emailUserRepository;
//	protected IEamilDAO<EmailUser> getDAO() throws Exception {
//		return emailUserRepository;
//	}
	
	public EmailUser getEmailUser(String account, String domainid)
			throws Exception {
		EmailUser user = emailUserRepository.findByAccountAndDomainid(account, domainid);
//		if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
//			user.setPassword(Security.decodeBASE64(user.getPassword()));
//		}
		return user;
	}

	public EmailUser getEmailUserByAccount(String account) throws Exception {
		return emailUserRepository.findByAccount(account);
	}

	//没有被引用，可以选择放弃
//	public DataPackage<EmailUser> getEmailUsers(String domainid, ParamsTable params)
//			throws Exception {
//		return ((EmailUserDAO)getDAO()).queryEmailUsers(domainid, params);
//	}


	public EmailUser getEmailUserByOwner(String ownerid, String domainid)
			throws Exception {
		EmailUser user = emailUserRepository.findByOwneridAndDomainid(ownerid, domainid);
		if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
			user.setPassword(Security.decodeBASE64(user.getPassword()));
		}
		return user;
	}

	public void doCreateEmailUser(EmailUser user) throws Exception {
		
		this.validateAccount(user);
		
		if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
			user.setPassword(Security.encodeToBASE64(user.getPassword()));
		}
		super.doCreate(user);
	}
	
	@Override
	public void doCreate(EmailValueObject vo) throws Exception {
		EmailUser user = (EmailUser) vo;

		EmailUser emailUser = this.validateAccount(user);
		if(emailUser != null && user.getOwnerid().equals(emailUser.getOwnerid()) && user.getAccount().equals(emailUser.getAccount()) && user.getDomainid().equals(emailUser.getDomainid())){
			return;
		}
		if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
			//user.setPassword(Security.encodeToBASE64(user.getPassword()));
		}
		user.setCreateDate(new Date());
		if(StringUtil.isBlank(user.getId())){
			user.setId(SequenceGenerator.getUUID());
		}
		emailUserRepository.save(user);
		//super.doCreate(vo);
	}

	public void doRemoveEmailUser(String id) throws Exception {
		super.doRemove(id);
	}

	public void doUpdateEmailUser(EmailUser user) throws Exception {

		this.validateAccount(user);
		
		if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
			user.setPassword(Security.encodeToBASE64(user.getPassword()));
		}
		super.doUpdate(user);
	}
	
	@Override
	public void doUpdate(EmailValueObject vo) throws Exception {
		EmailUser user = (EmailUser) vo;
		try {
			
			this.validateAccount(user);
			
			EmailUser po = emailUserRepository.findEmailUserById(vo.getId());
			if (po != null) {
				if (user.getPassword() != null && user.getPassword().trim().length() > 0) {
					//String base64 = Security.encodeToBASE64(user.getPassword());
					//user.setPassword(base64);
					//po.setPassword(base64);
				} else {
					//user.setPassword(((EmailUser)po).getPassword());
				}
				po.setAccount(user.getAccount());
				//if (Web.DEFAULT_SHOWPASSWORD.equals(user.getPassword())) {
				//	user.setPassword(((EmailUser)po).getPassword());
				//} else {
				//	user.setPassword(Security.encodeToBASE64(user.getPassword()));
				//}
				//PropertyUtils.copyProperties(po, user);
				po.setDefaultDepartment(user.getDefaultDepartment());
				emailUserRepository.save(po);
			} else {
				if (user != null && user.getPassword() != null && user.getPassword().trim().length() > 0) {
					user.setPassword(Security.encodeToBASE64(user.getPassword()));
				}
				emailUserRepository.save(user);
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw e;
		}
	}
	
	/**
	 * 校验邮件用户是否存在
	 * @param emailUser
	 * @return
	 * @throws Exception
	 */
	public EmailUser validateAccount(EmailUser emailUser)throws Exception {
		if(StringUtil.isBlank(emailUser.getAccount())){
			// 邮件账号为空不校验
			return emailUser;
		}
		EmailUser user = getEmailUser(emailUser.getAccount(), emailUser.getDomainid());
		if(user != null && !user.getOwnerid().equals(emailUser.getOwnerid())){
			// 该邮件账号已经被其他用户创建
			throw new OBPMValidateException(user.getAccount()
					+ "{*[core.email.account.create.error]*}" + " ["
					+ user.getName() + "] "
					+ "{*[core.email.account.change]*}!");
		}
		return user;
	}

}
