package com.teemlink.email.email.service;

import cn.myapps.auth.model.Domain;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.conf.UserAPI;
import com.teemlink.email.attachment.service.AttachmentProcessBean;
import com.teemlink.email.email.dao.IEamilDAO;

import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import com.teemlink.email.email.base.EmailValueObject;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.common.util.StringUtil;
import com.sun.mail.pop3.POP3Folder;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.attachment.service.AttachmentProcess;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.runtime.mail.Pop3ProtocolImpl;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.runtime.mail.Smtp;
import com.teemlink.email.runtime.model.EmailHeader;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.parser.MessageParser;
import com.teemlink.email.util.Constants;
import com.teemlink.email.util.EmailProcessUtil;
import com.teemlink.email.util.JacksonUtil;
import com.teemlink.email.util.Utility;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.activation.FileDataSource;
import javax.mail.Folder;
import javax.mail.Message;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
@Service
public class EmailProcessPop3Bean extends AbstractEmailServiceImpl<Email> implements
        EmailProcess{

    private static final long serialVersionUID = 4569714249064788780L;
    private transient ProtocolFactory protocolFactory;
    private static final Logger log = LoggerFactory.getLogger(EmailProcessPop3Bean.class);

    private final String cacheFolder = "EmailCache";
    private static ExecutorService cachedThreadPool = Executors.newCachedThreadPool();

    public EmailProcessPop3Bean(ProtocolFactory protocolFactory) throws Exception {
        this.protocolFactory = protocolFactory;
    }

    protected IEamilDAO<Email> getDAO() throws Exception {
        return null;
    }

    public void doMoveTo(String[] ids, EmailFolder folder) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    public void doMoveTo(String[] ids, EmailFolder folder, EmailFolder toFolder) throws Exception {
        String folderName = getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        protocol.moveMessagesByUID(parseLongs(ids), getFolderNameByEmailFolder(toFolder));
        protocol.disconnect();
    }

    public void doMoveToOtherFolder(Email email, String otherFolderid)
            throws Exception {
        String folderName = getFolderNameByEmailFolder(email.getEmailFolder());
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        Folder folder = protocolFactory.getConnectionMetaHandler().getFolderByUID(parseLong(otherFolderid));
        protocol.moveMessageByUID(parseLong(email.getId()), folder.getFullName());
        protocol.disconnect();
    }

    public void doToRecy(String[] ids) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    public void doToRecy(String[] ids, String folderid) throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(getFolderNameById(folderid));
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        protocol.moveMessagesByUID(parseLongs(ids), Constants.DEFAULT_FOLDER_REMOVED);
        protocol.disconnect();
    }

    public void doUpdateMarkRead(String[] ids, boolean flag) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    public void doUpdateRead(String messageId) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    private void saveEmailsAsCache(String folderId, List<Email> emails,String userid) throws Exception {

//		URI uri= EmailProcessImapBean.class.getClassLoader().getResource(cacheFolder).toURI();

        String uri = PropertyUtil.getPath() + "/" + cacheFolder + "/" + userid;;

        File folder = new File(uri);
        if(!folder.exists()){
            folder.mkdirs();
        }
        File file = new File(folder.getAbsolutePath()+File.separator+folderId+"_email_list.json");

        FileOutputStream out = new FileOutputStream(file);
        try{
            if(file.exists()){
                Collections.reverse(emails);
                JacksonUtil.save(emails, file);
            }else {
                file.createNewFile();
                out.write("[]".getBytes());
                Collections.reverse(emails);
                JacksonUtil.save(emails, file);
            }
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            if(out!=null){
                out.close();
            }
        }

    }

    private List<Email> getCacheEamils(String folderId,String userid,String unread,String smsForm,String smsSubject,String startDate,String endDate) throws Exception{
 //       System.out.println(EmailProcessImapBean.class.getClassLoader().getResource(""));
//		URI uri= EmailProcessImapBean.class.getClassLoader().getResource(cacheFolder).toURI();
        String uri = PropertyUtil.getPath() + "/" + cacheFolder + "/" + userid;;

        File folder = new File(uri);

        File file = new File(folder.getAbsolutePath()+File.separator+folderId+"_email_list.json");

        if(file.exists()){
            List<Email> list = JacksonUtil.get(file, List.class, Email.class);
            for (Iterator<Email> iterator = list.iterator(); iterator.hasNext(); ) {
                Email email =  iterator.next();
                if(!StringUtil.isBlank(smsForm)){
                    if(!email.getEmailBody().getFrom().contains(smsForm)){
                        iterator.remove();
                        continue;
                    }
                }
                if(!StringUtil.isBlank(smsSubject)){
                    if(!email.getEmailBody().getSubject().contains(smsSubject)){
                        iterator.remove();
                    }
                }
                if(!StringUtil.isBlank(unread)){
                    if(email.isRead() != Boolean.valueOf(unread)){
                        iterator.remove();
                    }
                }
            }

            return list;
        }else {
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            out.write("[]".getBytes());
            out.close();
            return new ArrayList<Email>();
        }
    }

    /**
     * 封装分页数据
     * @param rows
     * @param page
     * @param lines
     * @param resultList
     * @return
     */
    private DataPackage<Email> getResultDataPackage(int rows, int page, int lines , List<Email> resultList) {
        //初始化dataPackage对象
        DataPackage<Email> dataPackage = new DataPackage<Email>();

        //设置总行数
        dataPackage.setRowCount(resultList.size());

        //设置页码
        dataPackage.setPageNo(page);

        //设置每页显示行数
        dataPackage.setLinesPerPage(lines);

        try {
            dataPackage.setDatas(resultList.subList((page - 1) * lines,
                    (dataPackage.rowCount > (page) * lines ? (page) * lines
                            : dataPackage.rowCount)));
        } catch (Exception e) {
            e.printStackTrace();
        }

        //返回结果集
        return dataPackage;
    }

    public DataPackage<Email> getEmailsByFolderId(String folderid,String unread,String userid,
                                                  String departmentId,String sm_subject,String sm_from,String sm_to,String startdate,String enddate,
                                                  String isAjax,int page,int lines) throws Exception{

        List<Email> cacheEmails = new ArrayList<>();
        if(isAjax.equals("true")){
            //System.out.println("------------------------->从本地获取邮件列表");
            cacheEmails = getCacheEamils(folderid,userid,unread,sm_from,sm_subject,startdate,enddate);
            return getResultDataPackage(cacheEmails.size(),page,lines,cacheEmails);
        }else{
            String folderName = getFolderNameById(folderid);
            Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
            protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
            DataPackage<Email> dataPackage = new DataPackage<Email>();
            List<EmailHeader> result = protocol.fetchHeaders(page, lines, 0);
            dataPackage.rowCount = protocol.getTotalMessageCount();
            dataPackage.pageNo = page;
            dataPackage.linesPerPage = lines;
            Collection<Email> temp = new ArrayList<Email>();
            if (result != null) {
                Iterator<EmailHeader> it = result.iterator();
                while(it.hasNext()){
                    EmailHeader eh = it.next();
                    Email email = Email.valueOf(eh);
                    if (email != null) {
                        temp.add(email);
                    }
                }
            }

            //判断当前用户是否已经获取过此文件夹的所有数据
            if(EmailProcessUtil.userFolderMap.get(userid) == null){
                List<String> list = new ArrayList();
                list.add(folderid);
                EmailProcessUtil.userFolderMap.put(userid,list);
                //线程池执行
                getFolderAllEmails(folderid,userid);
            } else {
                List<String> list = EmailProcessUtil.userFolderMap.get(userid);
                if(!list.contains(folderid)){
                    getFolderAllEmails(folderid,userid);
                }
            }
            dataPackage.datas = temp;
            return dataPackage;
        }

    }

    /**
     * 异步拉取该文件夹下的全部邮件
     * @param folderid
     * @param userid
     */
    public void getFolderAllEmails(String folderid,String userid){
        cachedThreadPool.execute(new Runnable() {
            @Override
            public void run() {
                List<Email> allCacheEmails = new ArrayList<>();
                Iterator<EmailHeader> iterator = null;
                String folderName = getFolderNameById(folderid);
                Pop3ProtocolImpl protocol2 = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
                try {
                    protocol2.connect(Constants.CONNECT_TYPE_READ_WRITE);
                    iterator = protocol2.fetchAllHeaders().iterator();
                    while(iterator.hasNext()){
                        EmailHeader eh = iterator.next();
                        Email email = Email.valueOf(eh);
                        if (email != null) {
                            allCacheEmails.add(email);
                        }
                    }

                    saveEmailsAsCache(folderid, allCacheEmails,userid);
                } catch (Exception e) {
                    e.printStackTrace();
                }finally {
                    try {
                        protocol2.disconnect();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public DataPackage<Email> getEmailsByFolderUser(String folderid,String unread,String userid,
                                                    String departmentId,String sm_subject,String sm_from,String sm_to,String startdate,String enddate,
                                                    String isAjax,int page,int lines) throws Exception {
//		String unread = params.getParameterAsString("unread");
//		String userid = params.getParameterAsString("emailUserid");
//		String departmentId = params.getParameterAsString("departmentId");
//		String sm_subject = params.getParameterAsString("sm_subject");
//		String sm_from = Constants.emailAddress2Account(params.getParameterAsString("sm_from"));
//		String sm_to = params.getParameterAsString("sm_to");
//		String startdate = params.getParameterAsString("startdate");
//		String enddate = params.getParameterAsString("enddate");
//		String _currpage = params.getParameterAsString("_currpage");
//		String _pagelines = params.getParameterAsString("_pagelines");
//		String isAjax = params.getParameterAsString("isAjax");
//		int page = (_currpage != null && _currpage.length() > 0) ? Integer.parseInt(_currpage) : 1;
//		int lines = (_pagelines != null && _pagelines.length() > 0) ? Integer.parseInt(_pagelines) : 10;
        return getEmailsByFolderId(folderid, unread,userid,departmentId,sm_subject,sm_from,sm_to,startdate,enddate,isAjax,page,lines);
    }

    public int getEmailCount(EmailFolder folder, EmailUser user)
            throws Exception {
        String folderName = getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        return protocol.getTotalMessageCount();
    }

    public int getUnreadMessageCount(String folderid, EmailUser user)
            throws Exception {
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(getFolderNameById(folderid));
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        return protocol.getUnreadMessageCount();
    }

    public boolean sendEmail(Email email, EmailUser user) throws Exception {
        return sendEmail(email, user, false);
    }

    public boolean sendEmail(Email email, EmailUser user, boolean self)
            throws Exception {
        try {
            if (self) {
                POP3Folder pop3Folder = (POP3Folder) protocolFactory.getConnectionMetaHandler().getFolderByName(Constants.DEFAULT_FOLDER_SENT, Constants.SYSTEM_FOLDER_ID);
                EmailFolder folder = EmailFolder.valueOf(pop3Folder);
                this.doSaveEmail(email, folder);
            }
            String dId = user.getDomainid();

            UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
            JSONObject domain = userAPI.getDomainById(dId);

            Smtp smtp = new Smtp(protocolFactory.getProfile(), protocolFactory.getAuth(),domain.getString("functionDomain"));
            //Map result = smtp.sendEmail(valueOf(email), false);
            smtp.sendEmail(valueOf(email), false,domain.getString("functionDomain"));
            deleteAttachment(email);
            if (!StringUtil.isBlank(email.getId())) {
                Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(Constants.DEFAULT_FOLDER_DRAFTS);
                protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
                protocol.deletedMessageByUID(new long[]{Long.parseLong(email.getId())});
            }
            return true;
        } catch (Exception e) {
            log.warn("{}", e);
            throw e;
        }
    }

    public com.teemlink.email.runtime.model.Email valueOf(Email email) throws Exception {
        com.teemlink.email.runtime.model.Email result = new com.teemlink.email.runtime.model.Email();
        result.getBaseHeader().setBcc(Utility.stringToAddressArray(email.getEmailBody().getBcc()));
        result.getBaseHeader().setCc(Utility.stringToAddressArray(email.getEmailBody().getCc()));
        result.getBaseHeader().setFrom(Utility.stringToAddressArray(email.getEmailBody().getFrom()));
        result.getBaseHeader().setSubject(email.getEmailBody().getSubject());
        result.getBaseHeader().setTo(Utility.stringToAddressArray(email.getEmailBody().getTo()));
        EmailPart contentPart = new EmailPart();
        contentPart.setContent(email.getEmailBody().getContent(), "text/html;charset=utf-8");
        result.getParts().add(0, contentPart);
        if (email.getEmailBody().isMultipart()) {
            //AttachmentProcess aProcess = (AttachmentProcess) ProcessFactory.createProcess(AttachmentProcess.class);
            //Collection<Attachment> attachments = aProcess.getAttachmentsByEmail(email);
            Collection<Attachment> attachments = email.getEmailBody().getAttachments();
            for (Iterator<Attachment> it = attachments.iterator(); it.hasNext(); ) {
                Attachment attachment = (Attachment) it.next();
                EmailPart bodyPart = new EmailPart();
                String filename = attachment.getRealFileName();
                FileDataSource dataSource = new FileDataSource(attachment.getFileAllPath());
                bodyPart.setDataSource(dataSource);
                bodyPart.setFileName(filename);
                result.addPart(bodyPart);
            }
        }
        return result;
    }

    public String getFolderNameById(String id) {
        Folder folder = protocolFactory.getConnectionMetaHandler().getFolderByUID(parseLong(id));
        if (folder == null) {
            return "";
        }
        return folder.getFullName();
    }

    public String getFolderNameByEmailFolder(EmailFolder folder) {
        String folderName = folder.getName();
        if (StringUtil.isBlank(folderName)) {
            folderName = getFolderNameById(folder.getId());
        }
        return folderName;
    }

    private long parseLong(String str) {
        try {
            return Long.parseLong(str);
        } catch (Exception e) {
            return 0;
        }
    }

    private long[] parseLongs(String[] strs) {
        if (strs == null) {
            return new long[0];
        }
        long[] result = new long[strs.length];
        for (int i = 0; i < strs.length; i++) {
            result[i] = parseLong(strs[i]);
        }
        return result;
    }

    public void doUpdateMarkRead(String[] ids, boolean read, EmailFolder folder)
            throws Exception {
        String folderName = getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        for (int i = 0; i < ids.length; i++) {
            protocol.markAsReadByUID(parseLong(ids[i]), read);
        }
    }

    public void doUpdateRead(String emailid, EmailFolder folder)
            throws Exception {
        String folderName = getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        protocol.markAsReadByUID(parseLong(emailid));
    }

    @Override
    public EmailValueObject doView(String pk) throws Exception {
        throw new OBPMValidateException("{*[core.email.internal.error]*}");
    }

    //获取邮件缓存
    private Email getCacheEmail(String id,String name) throws Exception{
        //URI uri= EmailProcessImapBean.class.getClassLoader().getResource(cacheFolder).toURI();
        String uri = PropertyUtil.getPath() + "/" + cacheFolder;

        File folder = new File(uri);

        File file = new File(folder.getAbsolutePath()+File.separator+id+"_"+name+"_email.json");

        if(file.exists()){
            List<Email> emails=JacksonUtil.get(file, List.class, Email.class);

            if(emails==null||emails.isEmpty()){
                return null;
            }else{
                return emails.get(0);
            }
        }else {
            return null;
        }
    }

    //保存邮件缓存
    private void saveEmailAsCache(String id,String name ,Email email) throws Exception, URISyntaxException {

        //URI uri= EmailProcessImapBean.class.getClassLoader().getResource(cacheFolder).toURI();
        String uri = PropertyUtil.getPath() + "/" + cacheFolder;

        File folder = new File(uri);

        File file = new File(folder.getAbsolutePath()+File.separator+id+"_"+name+"_email.json");

        if(file.exists()){
            Collection<Email> emails = new ArrayList<Email>();
            emails.add(email);
            JacksonUtil.save(emails, file);
        }else {
            file.createNewFile();
            FileOutputStream out = new FileOutputStream(file);
            out.write("[]".getBytes());
            out.close();
            Collection<Email> emails = new ArrayList<Email>();
            emails.add(email);
            JacksonUtil.save(emails, file);
        }

    }

    public Email getEmailByID(String id, EmailFolder folder) throws Exception {
        //System.out.println("email id -------------->"+id);
        Email cacheEmail = getCacheEmail(id,folder.getId());
        //缓存已经存在返回缓存
        if(cacheEmail!=null){
            return cacheEmail;
        }else{
            String folderName = getFolderNameByEmailFolder(folder);
            Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
            protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
            Message message = protocol.getMessageByUID(parseLong(id));
            if (message != null) {
                Email email = Email.valueOf(MessageParser.parseMessage(message));
                if (email != null) {
                    email.setId(id);
                    email.getEmailFolder().setId(folder.getId());
                    email.getEmailFolder().setName(folderName);
                }
                //缓存邮件
                saveEmailAsCache(id,folder.getId(),email);
                return email;
            }
            protocol.disconnect();
            return null;
        }

    }

    public void doRemoveByFolder(String[] ids, EmailFolder folder)
            throws Exception {
        String folderName = getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        protocol.deletedMessageByUID(parseLongs(ids));
        protocol.disconnect();
    }

    @Override
    public void doCreate(EmailValueObject vo) throws Exception {

    }

    @Override
    public void doUpdate(EmailValueObject vo) throws Exception {

    }

    public void doSaveEmail(Email email, EmailFolder folder) throws Exception {
        if (folder == null) {
            throw new OBPMValidateException("EmailFolder can't null");
        }
        String folderName = getFolderNameByEmailFolder(folder);
        Pop3ProtocolImpl protocol = (Pop3ProtocolImpl) protocolFactory.getProtocol(folderName);
        protocol.connect(Constants.CONNECT_TYPE_READ_WRITE);
        com.teemlink.email.runtime.model.Email modelEmail = protocol.appendMessage(valueOf(email));
        if (modelEmail != null) {
            if (!StringUtil.isBlank(email.getId())) {
                protocol.deletedMessageByUID(new long[]{Long.parseLong(email.getId())});
            }
            email.setId(String.valueOf(modelEmail.getUid()));
            saveAttachment(email);
        }
    }

    private void saveAttachment(Email email) throws Exception {
        AttachmentProcess process = new AttachmentProcessBean();
        if (email.getEmailBody().isMultipart()) {
            for (Attachment att : email.getEmailBody().getAttachments()) {
                att.setEmailid(email.getId());
                att.setEmailBody(null);
                process.doUpdate(att);
            }
        }
    }

    private void deleteAttachment(Email email) throws Exception {
        AttachmentProcess process = new AttachmentProcessBean();
        if (email.getEmailBody().isMultipart()) {
            for (Attachment att : email.getEmailBody().getAttachments()) {
                att.setEmailid(email.getId());
                process.doRemove(att);
            }
        }
    }

    public void doRemoveEmailByEmailUser(String emailUserId) throws Exception{
        throw new UnsupportedOperationException();
    }
}
