package com.teemlink.email.email.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teemlink.email.attachment.model.Attachment;

import cn.myapps.common.util.StringUtil;
import com.teemlink.email.email.base.EmailValueObject;
import com.teemlink.email.util.FileUtil;

import javax.persistence.*;

@Entity
@Table(name="T_EMAIL_BODY")
public class EmailBody extends EmailValueObject {

	private static final long serialVersionUID = 357203441557251315L;
	@Id
	@Column(name = "ID")
	private String id;
	@Column(name = "SUBJECT")
	private String subject;
	@Column(name = "CONTENT")
	private String content;
	@Column(name = "E_FROM")
	private String from;
	@Column(name = "RE_TO")
	private String to;
	@Column(name = "RE_CC")
	private String cc;
	@Column(name = "RE_BCC")
	private String bcc;
	@Column(name = "SENDDATE")
	private Date sendDate;
	@OneToMany(targetEntity=Attachment.class,mappedBy="emailBody")
	private Set<Attachment> attachments;

	private boolean multipart;
	@Column(name = "E_FROMDEP")
	private String fromdep;

	public String getFromdep() {
		return fromdep;
	}

	public void setFromdep(String fromdep) {
		this.fromdep = fromdep;
	}

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the subject
	 */
	public String getSubject() {
		return subject;
	}

	/**
	 * @param subject
	 *            the subject to set
	 */
	public void setSubject(String subject) {
		this.subject = subject;
	}

	/**
	 * @return the content
	 */
	public String getContent() {
		return content;
	}

	/**
	 * @param content the content to set
	 */
	public void setContent(String content) {
		this.content = content;
	}

	/**
	 * @return the from
	 */
	public String getFrom() {
		return from;
	}

	/**
	 * @param from
	 *            the from to set
	 */
	public void setFrom(String from) {
		this.from = from;
	}

	/**
	 * @return the to
	 */
	public String getTo() {
		return to;
	}

	/**
	 * @param to
	 *            the to to set
	 */
	public void setTo(String to) {
		this.to = to;
	}

	/**
	 * @return the cc
	 */
	public String getCc() {
		return cc;
	}

	/**
	 * @param cc
	 *            the cc to set
	 */
	public void setCc(String cc) {
		this.cc = cc;
	}

	/**
	 * @return the bcc
	 */
	public String getBcc() {
		return bcc;
	}

	/**
	 * @param bcc
	 *            the bcc to set
	 */
	public void setBcc(String bcc) {
		this.bcc = bcc;
	}

	/**
	 * @return the sendDate
	 */
	public Date getSendDate() {
		return sendDate;
	}

	/**
	 * @param sendDate the sendDate to set
	 */
	public void setSendDate(Date sendDate) {
		this.sendDate = sendDate;
	}

	/**
	 * @return the attachments
	 */
	public Set<Attachment> getAttachments() {
		if (attachments == null) {
			attachments = new HashSet<Attachment>();
		}
		return attachments;
	}
	
	public void addAttachment(Attachment attachment) {
		if (attachment != null) {
			attachment.setEmailBody(this);
			getAttachments().add(attachment);
		}
	}

	/**
	 * @param attachments the attachments to set
	 */
	public void setAttachments(Set<Attachment> attachments) {
		this.attachments = attachments;
	}

	/**
	 * 判断邮件是否存在邮件
	 * @return the multipart
	 */
	public boolean isMultipart() {
		if (multipart) return multipart;
		
		if (attachments == null || attachments.isEmpty()) {
			this.multipart = false;
		} else {
			this.multipart = true;
		}
		return multipart;
	}

	/**
	 * @param multipart the multipart to set
	 */
	public void setMultipart(boolean multipart) {
		this.multipart = multipart;
	}
	@JsonIgnore
	public boolean isSentBcc() {
		return !StringUtil.isBlank(bcc);
	}
	@JsonIgnore
	public boolean isSentCc() {
		return !StringUtil.isBlank(cc);
	}

	@JsonIgnore
	public String getAttachmentsTotalSize(){
		long fileSize = 0;
		Iterator<Attachment> it = this.getAttachments().iterator();
		while(it.hasNext()){
			Attachment at = it.next();
			fileSize += at.getSize();
		}
		if(fileSize == 0){
			return "";
		}
		return FileUtil.FormetFileSize(fileSize);
	}
}
