package com.teemlink.email.email.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.runtime.model.EmailHeader;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.parser.HTMLMessageParser;

import com.teemlink.email.email.base.EmailValueObject;
import cn.myapps.common.util.StringUtil;

import javax.persistence.*;

@Entity
@Table(name="T_EMAIL")
public class Email extends EmailValueObject {

	private static final long serialVersionUID = 5747224167350343414L;

	public static final int MSGLEVEL_NORMAL = 0;
	
	public static final int MSGLEVEL_IMPORTANT = 1;
	
	public static final int MSGLEVEL_URGENCY = 2;

	@Id
	@Column(name = "ID")
	private String id;
	@ManyToOne(targetEntity = EmailBody.class)
	@JoinColumn(name = "EMAILBODY_ID", referencedColumnName = "ID")
	private EmailBody emailBody;
	@Column(name = "ISREAD")
	private boolean read;
	@ManyToOne(targetEntity = EmailFolder.class)
	@JoinColumn(name = "EMAILFOLDERID", referencedColumnName = "ID")
	private EmailFolder emailFolder;
	@Column(name = "READDATE")
	private Date readDate;
	@Column(name = "EMAILID")
	private long emailId;
	@Column(name = "ISREPLY")
	private boolean reply;
	@Column(name = "ISFORWARD")
	private boolean forward;
	@ManyToOne(targetEntity = EmailUser.class)
	@JoinColumn(name = "EMAINL_USER_ID", referencedColumnName = "ID")
	private EmailUser emailUser;
	@Column(name = "MSGLEVEL")
	private int msgLevel = 0;

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the emailBody
	 */
	public EmailBody getEmailBody() {
		if (emailBody == null) {
			emailBody = new EmailBody();
		}
		return emailBody;
	}

	/**
	 * @param emailBody the emailBody to set
	 */
	public void setEmailBody(EmailBody emailBody) {
		this.emailBody = emailBody;
	}

	/**
	 * @return the read
	 */
	public boolean isRead() {
		return read;
	}

	/**
	 * @param read
	 *            the read to set
	 */
	public void setRead(boolean read) {
		this.read = read;
	}

	/**
	 * @return the emailFolder
	 */
	public EmailFolder getEmailFolder() {
		if (emailFolder == null) {
			emailFolder = new EmailFolder();
		}
		return emailFolder;
	}

	/**
	 * @param emailFolder the emailFolder to set
	 */
	public void setEmailFolder(EmailFolder emailFolder) {
		this.emailFolder = emailFolder;
	}

	/**
	 * @return the readDate
	 */
	public Date getReadDate() {
		return readDate;
	}

	/**
	 * @param readDate
	 *            the readDate to set
	 */
	public void setReadDate(Date readDate) {
		this.readDate = readDate;
	}

	/**
	 * @return the emailId
	 */
	public long getEmailId() {
		return emailId;
	}

	/**
	 * @param emailId the emailId to set
	 */
	public void setEmailId(long emailId) {
		this.emailId = emailId;
	}

	/**
	 * @return the reply
	 */
	public boolean isReply() {
		return reply;
	}

	/**
	 * @param reply the reply to set
	 */
	public void setReply(boolean reply) {
		this.reply = reply;
	}

	/**
	 * @return the forward
	 */
	public boolean isForward() {
		return forward;
	}

	/**
	 * @param forward the forward to set
	 */
	public void setForward(boolean forward) {
		this.forward = forward;
	}

	/**
	 * @return the emailUser
	 */
	public EmailUser getEmailUser() {
		return emailUser;
	}

	/**
	 * @param emailUser the emailUser to set
	 */
	public void setEmailUser(EmailUser emailUser) {
		this.emailUser = emailUser;
	}
	
	public int getMsgLevel() {
		return msgLevel;
	}

	public void setMsgLevel(int msgLevel) {
		this.msgLevel = msgLevel;
	}

	@JsonIgnore
	public Collection<String> getReceiver() {
		Collection<String> result = new ArrayList<String>();
		if (!StringUtil.isBlank(emailBody.getTo())) {
			addReceiver(result, emailBody.getTo());
		}
		if (!StringUtil.isBlank(emailBody.getCc())) {
			addReceiver(result, emailBody.getCc());
		}
		if (!StringUtil.isBlank(emailBody.getBcc())) {
			addReceiver(result, emailBody.getBcc());
		}
		return result;
	}
	
	@JsonIgnore
	private void addReceiver(Collection<String> coll, String receiver) {
		String[] receivers = receiver.split(";");
		if (receivers == null || receivers.length == 1) {
			receivers = receiver.split(",");
		}
		for (int i = 0; i < receivers.length; i++) {
			String temp = receivers[i];
			if (!StringUtil.isBlank(temp)) {
				coll.add(temp);
			}
		}
	}
	
	@JsonIgnore
	public static Email valueOf(EmailHeader header) {
		Email email = null;
		if (header != null) {
			email = new Email();
			email.setId(String.valueOf(header.getEmailUID()));
			email.setRead(!header.getUnread());
			email.getEmailBody().setMultipart(header.isMultipart());
			email.getEmailBody().setCc(header.getCcString());
			email.getEmailBody().setSendDate(header.getDate());
			email.getEmailBody().setFrom(header.getFromString());
			email.getEmailBody().setTo(header.getToString());
			email.getEmailBody().setSubject(header.getSubject());
			email.getEmailFolder().setId(String.valueOf(header.getFolderid()));
		}
		return email;
	}
	
	/**
	 * 运行时邮件对象转换成平台邮件实体
	 * @param email
	 * @return
	 */
	@JsonIgnore
	public static Email valueOf(com.teemlink.email.runtime.model.Email email) {
		Email result = null;
		if (email != null) {
			result = new Email();
			result.setRead(!email.getBaseHeader().getUnread());
			result.getEmailBody().setCc(email.getCc());
			result.getEmailBody().setSendDate(email.getDate());
			result.getEmailBody().setFrom(email.getFrom());
			result.getEmailBody().setTo(email.getTo());
			result.getEmailBody().setSubject(email.getSubject());
			if (email.getParts() != null && !email.getParts().isEmpty()) {
				EmailPart part = (EmailPart) email.getParts().get(0);
				result.getEmailBody().setContent(HTMLMessageParser.toContent(part.getContent().toString()));
				for (int i = 1; i < email.getParts().size(); i++) {
					part = (EmailPart) email.getParts().get(i);
					if (!part.isHTMLText() && !part.isPlainText()) {
						Attachment attachment = new Attachment();
						attachment.setRealFileName(part.getFileName());
						attachment.setFileName(part.getFileName());
						attachment.setSize(part.getSize());
						result.getEmailBody().addAttachment(attachment);
					} else {
						if (part.isHTMLText()) {
							result.getEmailBody().setContent(part.getContent().toString());
						}
					}
				}
			}
		}
		return result;
	}

	@JsonIgnore
	public boolean isMultipart() {
		return getEmailBody().isMultipart();
	}
	
}
