package com.teemlink.email.attachment.service;

import java.util.Collection;

import javax.mail.Folder;
import javax.mail.Message;

import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.runtime.mail.ImapProtocolImpl;
import com.teemlink.email.runtime.mail.ProtocolFactory;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.runtime.parser.MessageParser;
import com.teemlink.email.util.Constants;

import com.teemlink.email.email.dao.IEamilDAO;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import cn.myapps.common.util.StringUtil;

public class AttachmentProcessImapBean extends AbstractEmailServiceImpl<Attachment>
		implements AttachmentProcess {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3358596562359189962L;
	private transient ProtocolFactory protocolFactory;
	
	public AttachmentProcessImapBean(ProtocolFactory protocolFactory) throws Exception {
		this.protocolFactory = protocolFactory;
	}
	
	protected IEamilDAO<Attachment> getDAO() throws Exception {
		return null;
	}

	public Attachment getAttachment(String emailid, EmailFolder folder, 
			String fileName) throws Exception {
		String folderName = getFolderNameByEmailFolder(folder);
		ImapProtocolImpl protocol = (ImapProtocolImpl) protocolFactory.getProtocol(folderName);
		if (protocol != null) {
			protocol.connect(Constants.CONNECT_TYPE_READ_ONLY);
			Message message = protocol.getMessageByUID(Long.parseLong(emailid));
			if (message != null) {
				EmailPart part = MessageParser.parseMessagePart(message, fileName);
				if (part != null) {
					return Attachment.valueOf(part);
				}
			}
		}
		return null;
	}
	
	public String getFolderNameByEmailFolder(EmailFolder folder) {
		String folderName = folder.getName();
		if (StringUtil.isBlank(folderName)) {
			folderName = getFolderNameById(folder.getId());
		}
		return folderName;
	}
	
	public String getFolderNameById(String id) {
		Folder folder = protocolFactory.getConnectionMetaHandler().getFolderByUID(Long.parseLong(id));
		return folder.getFullName();
	}

	public Collection<Attachment> getAttachmentsByEmail(Email email)
			throws Exception {
		return null;
	}

}
