package com.teemlink.email.attachment.service;

import java.util.Collection;
import java.util.Date;

import com.teemlink.email.attachment.dao.AttachmentDAO;
import com.teemlink.email.attachment.dao.AttachmentRepository;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.email.service.EmailProcess;
import com.teemlink.email.email.service.EmailProcessImapBean;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.util.AttachmentUtil;

import com.teemlink.email.email.dao.IEamilDAO;
import com.teemlink.email.email.service.AbstractEmailServiceImpl;
import com.teemlink.email.email.base.EmailValueObject;
import org.springframework.beans.factory.annotation.Autowired;

public class AttachmentProcessBean extends AbstractEmailServiceImpl<Attachment> implements
		AttachmentProcess {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1933447807515757290L;

	@Autowired
	AttachmentRepository attachmentRepository;

	protected IEamilDAO<Attachment> getDAO() throws Exception {
		return null;
	}
	
//	public static void main(String[] args) {
//		try {
//			//System.out.println(new AttachmentProcessBean().doView(""));
//			EmailBodyProcess rp = new EmailBodyProcessBean();
//			EmailBody body = new EmailBody();
//			body.setContent("----");
//			rp.doCreate(body);
//
//			//System.out.println(rp.doView(body.getId()));
//
//			EmailFolderProcess ep = new EmailFolderProcessBean();
//			ep.initCreatDefaultMailFolder();
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//	}

	public Attachment getAttachment(String emailid,
			EmailFolder folder, String fileName) throws Exception {
		EmailProcess process = new EmailProcessImapBean(null);
		Email email = (Email) process.doView(emailid);
		if (email != null
				&& email.getEmailBody().isMultipart()) {
			for (Attachment attachment : email.getEmailBody().getAttachments()) {
				if (attachment.getRealFileName().equals(fileName)) {
					return attachment;
				}
			}
		}
		return null;
	}

	@Override
	public void doCreate(EmailValueObject vo) throws Exception {
		((Attachment)vo).setCreateDate(new Date());

		attachmentRepository.save((Attachment)vo);
		//super.doCreate(vo);
	}
	
	@Override
	public void doRemove(String pk) throws Exception {
		Attachment attachment = (Attachment) doView(pk);
		if (attachment != null) {
			doRemove(attachment);
		}
	}
	
	@Override
	public void doRemove(EmailValueObject obj) throws Exception {
		//PersistenceUtils.currentSession().clear();//清除session
		//super.doRemove(obj);
		attachmentRepository.delete((Attachment) obj);
		AttachmentUtil.removeAttachmentFile(((Attachment)obj).getFileName());
	}

	public Collection<Attachment> getAttachmentsByEmail(Email email)
			throws Exception {
		return ((AttachmentDAO)getDAO()).queryAttachmentByEmails(email);
	}

}
