package com.teemlink.email.attachment.model;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.teemlink.email.email.model.EmailBody;
import com.teemlink.email.runtime.model.EmailPart;
import com.teemlink.email.util.AttachmentUtil;
import com.teemlink.email.util.Utility;

import com.teemlink.email.email.base.EmailValueObject;

import javax.persistence.*;

/**
 * 邮件附件
 * @author Tom
 *
 */

@Entity
@Table(name="T_EMAIL_ATTACHMENT")
public class Attachment extends EmailValueObject {

	private static final long serialVersionUID = 1L;
	@Id
	@Column(name = "ID")
	private String id;

	@JsonBackReference
	@ManyToOne(targetEntity = EmailBody.class)
	@JoinColumn(name = "EMAILBODY_ID", referencedColumnName = "ID")
	private EmailBody emailBody;
	@Column(name = "FILENAME")
	private String fileName;
	@Column(name = "REALFILENAME")
	private String realFileName;
	@Column(name = "FILETEXT")
	private byte[] fileText;
	@Column(name = "PATH")
	private String path;
	@Column(name = "CREATDATE")
	private Date createDate;
	@Column(name = "FILESIZE")
	private long size;
	@Transient
	private Object content;
	@Column(name = "EMAILID")
	private String emailid;

	/**
	 * @return the id
	 */
	public String getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id) {
		this.id = id;
	}

	/**
	 * @return the emailBody
	 */
	public EmailBody getEmailBody() {
		return emailBody;
	}

	/**
	 * @param emailBody the emailBody to set
	 */
	public void setEmailBody(EmailBody emailBody) {
		this.emailBody = emailBody;
	}

	/**
	 * @return the fileName
	 */
	public String getFileName() {
		return fileName;
	}

	/**
	 * @param fileName
	 *            the fileName to set
	 */
	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * @return the realFileName
	 */
	public String getRealFileName() {
		return realFileName;
	}

	/**
	 * @param realFileName
	 *            the realFileName to set
	 */
	public void setRealFileName(String realFileName) {
		this.realFileName = realFileName;
	}

	/**
	 * @return the fileText
	 */
	public byte[] getFileText() {
		return fileText;
	}

	/**
	 * @param fileText
	 *            the fileText to set
	 */
	public void setFileText(byte[] fileText) {
		this.fileText = fileText;
	}

	/**
	 * @return the path
	 */
	public String getPath() {
		return path;
	}

	/**
	 * @param path
	 *            the path to set
	 */
	public void setPath(String path) {
		this.path = path;
	}

	/**
	 * @return the createDate
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * @param createDate
	 *            the createDate to set
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}
	
	@JsonIgnore
	public String getFileAllPath() {
//		if (getPath() != null) {
//			if (path.endsWith(File.separator)) {
//				return path + getFileName();
//			} else {
//				return path + File.separator + getFileName();
//			}
//		}
//		return "";
		try {
//			return AttachmentUtil.getAttachmentDir() + File.separator + getFileName();
			return AttachmentUtil.getAttachmentDir() + "/" + getFileName();
		} catch (Exception e) {
			return "";
		}
	}

	/**
	 * @return the size
	 */
	public long getSize() {
		return size;
	}

	/**
	 * @param size the size to set
	 */
	public void setSize(long size) {
		this.size = size;
	}
	
	@JsonIgnore
	public String getSizeString() {
		return Utility.sizeToHumanReadable(size);
	}

	/**
	 * @return the content
	 */
	public Object getContent() {
		return content;
	}

	/**
	 * @param content the content to set
	 */
	public void setContent(Object content) {
		this.content = content;
	}
	
	public static Attachment valueOf(EmailPart part) {
		if (part != null) {
			Attachment attachment = new Attachment();
			attachment.setContent(part.getContent());
			attachment.setRealFileName(part.getFileName());
			attachment.setFileName(part.getFileName());
			attachment.setSize(part.getSize());
			return attachment;
		}
		return null;
	}

	/**
	 * @return the emailid
	 */
	public String getEmailid() {
		return emailid;
	}

	/**
	 * @param emailid the emailid to set
	 */
	public void setEmailid(String emailid) {
		this.emailid = emailid;
	}

}
