package cn.myapps.email.controller;

import cn.myapps.auth.model.Domain;

import cn.myapps.common.controller.Resource;
import cn.myapps.common.data.DataPackage;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.PropertyUtil;
import cn.myapps.email.model.WebUser;
import com.teemlink.email.attachment.model.Attachment;
import com.teemlink.email.attachment.service.AttachmentProcess;
import com.teemlink.email.attachment.service.AttachmentProcessBean;
import com.teemlink.email.email.model.Email;
import com.teemlink.email.email.model.EmailBody;
import com.teemlink.email.email.model.EmailUser;
import com.teemlink.email.email.service.EmailProcess;
import com.teemlink.email.email.service.EmailUserProcess;

import com.teemlink.email.folder.action.EmailFolderHelper;
import com.teemlink.email.folder.model.EmailFolder;
import com.teemlink.email.folder.service.EmailFolderProcess;
import com.teemlink.email.util.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;

/**
 * email RESTful
 * @author gary
 */
@Api(tags = "邮件执行模块")
@Component
@RequestMapping(path = "/api/email", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EmailController extends AbstractEmailController {

    @Autowired
    private EmailUserProcess emailUserProcess;

    @Autowired
    protected HttpServletResponse response;

    /**
     * 邮箱用户登录
     * @param content
     * @return
     */
    @PostMapping("/userLogin")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "邮箱用户登录", notes = "邮箱用户登录")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource emailLogin(@RequestBody String content){
        try {
            JSONObject jsonObject = JSONObject.fromObject(content);
            //ownerid  name account password
            EmailUser emailUser = (EmailUser)json2obj(jsonObject,EmailUser.class);
            WebUser webUser = getUser();
            if(webUser == null){
                return error(500,"前台用户未登录",null);
            }
            emailUser.setDomainid(webUser.getDomainid());
            if (StringUtils.isBlank(emailUser.getId())) {
                emailUserProcess.doCreate(emailUser);
            } else {
                emailUserProcess.doUpdate(emailUser);
            }
            //EmailUserHelper.loginEmailSystem(webUser, emailUser);
            webUser.setEmailUser(emailUser);
            EmailProcessUtil.userFolderMap.put(emailUser.getAccount(),null);
            if (webUser.getConnectionMetaHandler(request) == null) {
                throw new Exception();
            }
            setUser(webUser);
            return success("ok","登录成功");
        } catch (Exception e){
            e.printStackTrace();
            return error(500,"账号或密码错误",null);
        }
    }

    /**
     * 获取邮箱后缀
     * @return
     */
    @GetMapping("/getEmailSuffix")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取邮箱后缀", notes = "获取邮箱后缀")
    public Resource getEmailSuffix(){
        String data = "";
        try{
            Domain domainVO = getUser().getDomain();
            data = domainVO.getFunctionDomain();
        }catch (Exception e){
            e.printStackTrace();
        }
        return success("ok",data);
    }

    /**
     * 获取邮箱文件夹列表
     * @return
     */
    @GetMapping("/getFolderList")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取邮箱文件夹列表", notes = "获取邮箱文件夹列表")
    public Resource getFolderList(){
        Collection<EmailFolder> systemFolders = new ArrayList<>();
        try{
            WebUser webUser = getUser();
            systemFolders = EmailFolderHelper.getSystemFolders(webUser);
        }catch (Exception e){
            e.printStackTrace();
        }
        return success("ok",systemFolders);
    }

    /**
     * 获取邮箱文件夹中邮件列表
     * @param folderId 文件夹id
     * @param unread    已读、未读
     * @param departmentId 发件人所在部门id
     * @param smSubject 主题
     * @param smFrom 发件人
     * @param startDate 开始日期
     * @param endDate 结束日期
     * @param pageNo 页码
     * @param linesPerPage 每页显示数据数
     * @return
     */
    @GetMapping("/getFolderEmails")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取邮箱文件夹中邮件列表", notes = "获取邮箱文件夹中邮件列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "folderId",value = "文件夹id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "unread",value = "已读、未读",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "departmentId",value = "发件人所在部门id",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "smSubject",value = "主题",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "smFrom",value = "发件人",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "startDate",value = "开始日期",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "endDate",value = "结束日期",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "pageNo",value = "页码",required = false,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "linesPerPage",value = "每页显示数据数",required = false,paramType = "query",dataType = "string")
    })
    public Resource getEmailsByFolder(@RequestParam String folderId,String unread,String departmentId,String smSubject,String smFrom,String startDate,String endDate,String pageNo,String linesPerPage){
        try {
            EmailProcess emailProcess = (EmailProcess) EmailProcessUtil.createProcess(EmailProcess.class, request,getUser());
            EmailUser user = getUser().getEmailUser();

            EmailFolder folder = null;
            EmailFolderProcess folderProcess = (EmailFolderProcess) EmailProcessUtil.createProcess(EmailFolderProcess.class, request,getUser());
            if (Utility.isBlank(folderId)) {
                folder = folderProcess.getEmailFolderByOwnerId(Constants.DEFAULT_FOLDER_INBOX, Constants.SYSTEM_FOLDER_ID);
                folderId = folder.getId();
            } else {
                folder = folderProcess.getEmailFolderById(folderId);
            }
            if (folder == null) {
                throw new OBPMValidateException("文件夹不存在");
            }

            smFrom = Constants.emailAddress2Account(smFrom);
            String isAjax = "false";
            if(!StringUtils.isBlank(unread) || !StringUtils.isBlank(smSubject) || !StringUtils.isBlank(smFrom) || !StringUtils.isBlank(startDate) || !StringUtils.isBlank(endDate)){
                isAjax = "true";
            }
            int page = (pageNo != null && pageNo.length() > 0) ? Integer.parseInt(pageNo) : 1;
            int lines = (linesPerPage != null && linesPerPage.length() > 0) ? Integer.parseInt(linesPerPage) : 10;
            DataPackage<Email> emails = emailProcess.getEmailsByFolderUser(folderId, unread,user.getAccount(),
                    departmentId,smSubject,smFrom,"",startDate,endDate,isAjax,page,lines);
            return success("ok",emails);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
    }

    /**
     * 获取邮件详情
     * @param emailId
     * @param folderId
     * @return
     */
    @GetMapping("/getEmail")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "获取邮件详情", notes = "获取邮件详情")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "emailId",value = "邮件id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "folderId",value = "文件夹id",required = true,paramType = "query",dataType = "string")
    })
    public Resource doGetEamil(@RequestParam String emailId,@RequestParam String folderId){
        try {
            EmailProcess emailProcess = (EmailProcess) EmailProcessUtil.createProcess(EmailProcess.class, request,getUser());
            EmailFolderProcess folderProcess = (EmailFolderProcess) EmailProcessUtil.createProcess(EmailFolderProcess.class, request,getUser());
            EmailFolder folder = folderProcess.getEmailFolderById(folderId);
            Environment env = Environment.getInstance();
            env.setContextPath(request.getContextPath());
            Email email = emailProcess.getEmailByID(emailId, folder);
            if (email != null) {

                if (Constants.DEFAULT_FOLDER_DRAFTS.equals(email.getEmailFolder().getName())) {
                     if (!email.isRead()) {
                        email.setRead(true);
                        email.setReadDate(new Date());
                        emailProcess.doUpdate(email);
                    }
                }
                if (!email.isRead()) {
                    email.setRead(true);
                    email.setReadDate(new Date());
                    emailProcess.doUpdate(email);
                }
            }
            return success("ok",email);

        } catch (Exception e) {
           e.printStackTrace();
           return error(500,e.getMessage(),null);
        }
    }

    /**
     * 删除邮件(可批量)
     * @param folderId 文件夹id
     * @param ids 邮件id
     * @return
     */
    @DeleteMapping("/removeEmail")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除邮件", notes = "删除邮件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids",value = "邮件id",required = true,paramType = "body",dataType = "string"),
            @ApiImplicitParam(name = "folderId",value = "文件夹id",required = true,paramType = "query",dataType = "string")
    })
    public Resource doDeleteEmail(@RequestParam String folderId,@RequestBody String[] ids ){
        try {
            EmailProcess emailProcess = (EmailProcess) EmailProcessUtil.createProcess(EmailProcess.class, request,getUser());
            emailProcess.doToRecy(ids, folderId);
            return success("ok",null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }

    }

    /**
     * 彻底删除邮件(可批量)
     * @param folderId 文件夹id
     * @param ids 邮件id
     * @return
     */
    @DeleteMapping("/deleteEmail")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "彻底删除邮件", notes = "彻底删除邮件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids",value = "邮件id",required = true,paramType = "body",dataType = "string"),
            @ApiImplicitParam(name = "folderId",value = "文件夹id",required = true,paramType = "query",dataType = "string")
    })
    public Resource completelyDeleteEmail(@RequestParam String folderId,@RequestBody String[] ids ){
        try {
            EmailProcess emailProcess = (EmailProcess) EmailProcessUtil.createProcess(EmailProcess.class, request,getUser());
            EmailFolderProcess folderProcess = (EmailFolderProcess) EmailProcessUtil.createProcess(EmailFolderProcess.class, request,getUser());
            EmailFolder folder = folderProcess.getEmailFolderById(folderId);
            emailProcess.doRemoveByFolder(ids, folder);
            return success("ok",null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }

    }

    /**
     * 发送邮件
     * @param content from 发件人 to 收件人 subject 主题 content 内容 cc 抄送 bcc 密送
     * @param folderId
     * @return
     */
    @PostMapping("/sendEmail")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "发送邮件", notes = "发送邮件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "content",value = "请求包体",required = true,paramType = "body",dataType = "string"),
            @ApiImplicitParam(name = "folderId",value = "文件夹id",required = true,paramType = "query",dataType = "string")
    })
    public Resource sendEmail(@RequestBody String content,String folderId){
        try {
            EmailProcess emailProcess = (EmailProcess) EmailProcessUtil.createProcess(EmailProcess.class, request,getUser());
            JSONObject jsonObject = JSONObject.fromObject(content);
            EmailBody emailBody = (EmailBody) json2obj(jsonObject, EmailBody.class);
            //附件id
            JSONArray ids = jsonObject.getJSONArray("attids");
            String[] attids = null;
            if(ids != null && ids.size()>0){
                //object[]转string[]
                attids = Arrays.copyOf(ids.toArray(),ids.toArray().length,String[].class);
            }
            EmailFolderProcess emailFolderProcess = (EmailFolderProcess) EmailProcessUtil.createProcess(EmailFolderProcess.class, request,getUser());
            EmailFolder folder = emailFolderProcess.getEmailFolderById(folderId);
            Email email = new Email();
            email.setEmailBody(emailBody);
            email.setEmailFolder(folder);

            EmailUser user = getUser().getEmailUser();

            if (folder == null) {
                folder = EmailFolderHelper.createEmptyEmailFolder();
            }
            if (email.getEmailBody() == null) {
                throw new OBPMValidateException();
            }
            this.addAttachmentsByIds(email,attids);
            boolean sentBox = false;
            if (folder.getName().equals(Constants.DEFAULT_FOLDER_DRAFTS)) {
                email.setEmailFolder(folder);
                email.setEmailUser(user);
                emailProcess.doSaveEmail(email, folder);
            } else if (folder.getName().equals(Constants.DEFAULT_FOLDER_SENT)) {
                sentBox = true;
                if (!checkEmailAddress(email)) {
                    throw new OBPMValidateException("Email address error");
                }
                email.setEmailFolder(folder);
                emailProcess.sendEmail(email, user, sentBox);
            }

            return success("ok",email);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }

    }

    /**
     * 标记邮件(已读、未读)
     *
     * @param mark  0--未读 1--已读
     * @param folderId 文件夹id
     * @param ids 邮件id
     * @return
     */
    @PostMapping("/markEmail")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "标记邮件", notes = "标记邮件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "mark",value = "标记",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "folderId",value = "文件夹id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "ids",value = "请求包体",required = true,paramType = "body",dataType = "string")
    })
    public Resource doMarkEmail(@RequestParam String mark,@RequestParam String folderId,@RequestBody String[] ids){
        try {
            EmailProcess emailProcess = (EmailProcess) EmailProcessUtil.createProcess(EmailProcess.class, request,getUser());

            EmailFolder folder = new EmailFolder();
            folder.setId(folderId);

            switch (mark) {
                case "0": // 未读
                    emailProcess.doUpdateMarkRead(ids, false, folder);
                    break;

                case "1": // 已读
                    emailProcess.doUpdateMarkRead(ids, true, folder);
                    break;
            }
            return success("ok",null);

        } catch (Exception e) {
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }

    }

    /**
     * 邮件附件上传
     * @param multipartFiles 多个文件
     * @return
     * @throws Exception
     */
    @PostMapping("/uploadAttachment")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "邮件附件上传", notes = "邮件附件上传")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "multipartFiles",value = "多个文件",required = true,paramType = "query",dataType = "string")
    })
    public Resource uploadAttachment(@RequestParam("file") MultipartFile[] multipartFiles){
        try {
            /** 所有文件的总大小 */
            long ATTACHMENT_MAX_SIZE = EmailConfig.getInteger(
                    "attachment.max.size", 50 * 1000 * 1024); // 50M
            /** 每次最多上传文件个数 */
            long ATTACHMENT_MAX_COUNT = EmailConfig.getInteger(
                    "attachment.max.count", 3); // 5
            Attachment attachment = new Attachment();

            DiskFileItemFactory factory = new DiskFileItemFactory();
            // 设置内存缓冲区，超过后写入临时文件
            factory.setSizeThreshold(1024 * 1000 * 10);
            // 设置临时文件存储位置
            File tempFile = AttachmentUtil.createAttachmentTempFile();
            factory.setRepository(tempFile);
            ServletFileUpload upload = new ServletFileUpload(factory);
            // 设置单个文件的最大上传值
            upload.setFileSizeMax(ATTACHMENT_MAX_SIZE);
            // 设置整个request的最大值
            upload.setSizeMax(ATTACHMENT_MAX_SIZE);

            JSONObject json = new JSONObject();
            if(multipartFiles.length > 0 ){
                // 处理文件上传
                for (int i = 0; i < multipartFiles.length; i++) {

                    // 获取上传文件
                    MultipartFile multipartFile = multipartFiles[i];

                    // 保存文件
                    String fileName = multipartFile.getName();
                    fileName = fileName.replace(" ", "");
                    attachment.setRealFileName(fileName);
                    File file = AttachmentUtil.createAttachmentFile(fileName);
                    attachment.setFileName(file.getName());
                    attachment.setSize(multipartFile.getSize());
                    attachment.setPath(file.getPath());
                    multipartFile.transferTo(file);

                    AttachmentProcess process = new AttachmentProcessBean();
                    process.doCreate(attachment);
                    String dealPath = dealPath(attachment.getPath());

                    json.put("id",attachment.getId());
                    json.put("fileName",attachment.getRealFileName());
                    json.put("path",dealPath);

                }
            }

            return success("ok",json);

            }catch (Exception e){
                e.printStackTrace();
                return error(500,e.getMessage(),null);
            } finally {
                try {
//                    PersistenceUtils.closeSessionAndConnection();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
    }

    /**
     * 移动邮件到另一个文件夹
     * @param currentFolderId 当前文件夹id
     * @param toFolderId 目标文件夹id
     * @param ids 邮件id
     * @return
     */
    @PutMapping("/moveToFolder")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "移动邮件到另一个文件夹", notes = "移动邮件到另一个文件夹")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids",value = "邮件id",required = true,paramType = "body",dataType = "string"),
            @ApiImplicitParam(name = "currentFolderId",value = "当前文件夹id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "toFolderId",value = "目标文件夹id",required = true,paramType = "query",dataType = "string")
    })
    public Resource moveToFolder(@RequestBody String [] ids,@RequestParam String currentFolderId,@RequestParam String toFolderId){
        try {

            EmailFolderProcess folderProcess = (EmailFolderProcess) EmailProcessUtil.createProcess(EmailFolderProcess.class, request,getUser());
            EmailFolder toFolder = folderProcess.getEmailFolderById(toFolderId);
            EmailFolder currentFolder = folderProcess.getEmailFolderById(currentFolderId);
            EmailProcess emailProcess = (EmailProcess) EmailProcessUtil.createProcess(EmailProcess.class, request,getUser());
            if (toFolder == null || currentFolder == null) {
                return error(500,"{*[core.email.move.error]*}",null);
            } else {
                emailProcess.doMoveTo(ids, currentFolder, toFolder);
            }
        } catch (OBPMValidateException e) {
            e.printStackTrace();
            return error(500,e.getValidateMessage(),null);
        }catch (Exception e) {
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }
        return success("ok",null);
    }

    /**
     * 删除邮件附件
     * @param id 邮件附件id
     * @return
     */
    @DeleteMapping("/removeAttachment")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "删除邮件附件", notes = "删除邮件附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id",value = "邮件附件id",required = true,paramType = "query",dataType = "string")
    })
    public Resource removeAttachment(@RequestParam String id){
        try {
            AttachmentProcess aProcess = new AttachmentProcessBean();
            return success("ok",null);
        } catch (Exception e) {
            e.printStackTrace();
            return error(500,e.getMessage(),null);
        }

    }

    /**
     * 下载邮件附件
     * @param folderId 文件夹id
     * @param emailId 邮件id
     * @param fileName 文件名称
     * @return
     */
    @PostMapping("/downloadAttachment")
    @ResponseStatus(HttpStatus.OK)
    @ApiOperation(value = "下载邮件附件", notes = "下载邮件附件")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "folderId",value = "文件夹id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "emailId",value = "邮件id",required = true,paramType = "query",dataType = "string"),
            @ApiImplicitParam(name = "fileName",value = "文件名称",required = true,paramType = "query",dataType = "string")
    })
    public void doDownload(@RequestParam String folderId,@RequestParam String emailId,@RequestParam String fileName) {
        try {
            AttachmentProcess aProcess = (AttachmentProcess)EmailProcessUtil.createProcess(AttachmentProcess.class, request,getUser());

            EmailFolderProcess emailFolderProcess = (EmailFolderProcess) EmailProcessUtil.createProcess(EmailFolderProcess.class, request,getUser());
            EmailFolder folder = emailFolderProcess.getEmailFolderById(folderId);
            //fileName = fileName != null ? URLEncoder.encode(fileName, "ISO-8859-1") : null;
            if (folder != null && !StringUtils.isBlank(emailId)
                    && !StringUtils.isBlank(fileName)) {
                //fileName = URLDecoder.decode(fileName, "UTF-8");
                Attachment attachment = aProcess.getAttachment(emailId, folder, fileName);
                if (attachment != null) {

                    String encoding = EmailConfig.getString("charset", "UTF-8");
                    // application/octet-stream  application/x-download
                    response.setContentType("application/octet-stream; charset=" + encoding);
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + URLEncoder.encode(fileName, encoding) + "\"");
                    if (attachment.getContent() instanceof ByteArrayOutputStream) {
                        ByteArrayOutputStream bos = (ByteArrayOutputStream) attachment.getContent();
                        bos.writeTo(response.getOutputStream());
                    } else {
                        File file = new File(attachment.getFileAllPath());
                        if (file.exists()) {
                            setDownloadFile(response, file);
                        } else {
                            throw new OBPMValidateException("找不到邮件");
                        }
                    }
                }
            }

        }catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDownloadFile(HttpServletResponse response, File file) throws Exception {
        OutputStream os = null;
        BufferedInputStream reader = null;
        try {
            String encoding = Environment.getInstance().getEncoding();
            response.setContentType("application/x-download; charset=" + encoding + "");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(file.getName(), encoding));
            os = response.getOutputStream();
            reader = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[4096];
            int i = -1;
            while ((i = reader.read(buffer)) != -1) {
                os.write(buffer, 0, i);
            }
            os.flush();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (os != null) {
                reader.close();
            }
            if ( reader != null) {
                reader.close();
            }
        }
    }

    // 重构路径
    public String dealPath(String path) {
        String attachmentDir = EmailConfig.getString("attachment.dir", PropertyUtil.getPath()+"/"
                + "email" + "/" + "attachment");

        String[] strings = path.split("\\\\");
        String string2 = "";
        for (int i = 0; i < strings.length; i++) {
            if (i == strings.length - 1) {
                string2 = string2 + strings[i];
            } else {
                string2 = string2 + strings[i] + "/";
            }

        }
        String string3 = string2.substring(string2.indexOf(attachmentDir));
        return string3;
    }

    private boolean checkEmailAddress(Email email) {
        if (email.getEmailBody().getTo() == null) {
            return false;
        }
        String strings[] = email.getEmailBody().getTo().split(";");
        if (strings.length > 1) {
            for (int i = 0; i < strings.length; i++) {
                String address = Constants.emailShowAddressToAddress(strings[i]);
                if (!Utility.checkEmailAddress(address)) {
                    return false;
                }
            }
        } else {
            strings = email.getEmailBody().getTo().split(",");
            for (int i = 0; i < strings.length; i++) {
                String address = Constants.emailShowAddressToAddress(strings[i]);
                if (!Utility.checkEmailAddress(address)) {
                    return false;
                }
            }
        }
        return true;
    }

    private void addAttachmentsByIds(Email email,String[] attids) {
        try {
            AttachmentProcess process = new AttachmentProcessBean();
            if (attids != null)
                for (int i = 0; i < attids.length; i++) {
                    Attachment temp = (Attachment) process.doView(attids[i]);
                    if (temp == null) {
                        continue;
                    }
                    //if (EmailConfig.isInternalEmail()) {
                    email.getEmailBody().addAttachment(temp);
                    //}
                }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}