package cn.myapps.email.controller;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import cn.myapps.auth.model.Domain;
import cn.myapps.common.util.SpringApplicationContextUtil;
import cn.myapps.conf.FeignConfig;
import cn.myapps.conf.UserAPI;
import cn.myapps.email.model.WebUser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

import com.jayway.jsonpath.PathNotFoundException;

import cn.myapps.common.controller.ErrorMessage;
import cn.myapps.common.controller.Resource;
import cn.myapps.common.controller.ResourceNotFoundException;
import cn.myapps.common.data.ParamsTable;
import cn.myapps.common.exception.OBPMValidateException;
import cn.myapps.common.util.Security;
import cn.myapps.common.util.StringUtil;
import net.sf.json.JSONObject;

/**
 * 定义了基本的运行时Restful接口信息，用于处理共同的错误返回码以及其他信息。<br/>
 * 对应资源的Restful接口需要实现这个抽象类并定义为一个 {@link Component}便可由spring自动扫描装配。
 * 
 * @author ahan
 *
 */
@RestController
public abstract class AbstractEmailController {

	@Autowired
	protected HttpServletRequest request;

	@Autowired
	protected HttpSession session;

	private String domain;

	WebUser frontUser;

	/**
	 * Retrieve WebUser Object.
	 * 
	 * @return The current WebUser Object.
	 * @throws Exception
	 */
	protected WebUser getUser() throws Exception {
		if(frontUser==null){
			WebUser user = new WebUser();
			String userId = Security.getUserIdFromToken(request);
			FeignConfig.ACCESS_TOKEN = Security.getToken(userId);
			UserAPI userAPI = SpringApplicationContextUtil.getBean(UserAPI.class);
			Map<String,Object> userMap = new LinkedHashMap<>();
			userMap= (Map<String, Object>) userAPI.getLoginUser().getData();

			user.setId(userId);
			user.setName((String) userMap.get("name"));
			user.setDomainid((String) userMap.get("domainId"));
			user.setDefaultDepartment((String) userMap.get("deptId"));
            JSONObject domain = userAPI.getDomainById(user.getDomainid());
            Domain domainVo = (Domain) json2obj(domain, Domain.class);
            user.setDomain(domainVo);
            frontUser = user;
		}
		return frontUser;
	}

	protected void setUser(WebUser user) throws Exception {
		frontUser = user;
	}

	protected String getUserId() throws Exception {

		String userId = null;
		try {
			userId = Security.getUserIdFromToken(request);
			if (userId == null) {
				userId = Security.getDebugUserIdFromToken(request);
			}
		} catch (Exception e) {
			return null;
		}

		return userId;
	}

	/**
	 * Retrieve the ParamsTable
	 * 
	 * @return ParamsTable
	 */
	public ParamsTable getParams() {
		ParamsTable pm = ParamsTable.convertHTTP(request);

		// put the domain id to parameters table.
//		if (getDomain() != null)
//			pm.setParameter("domainid", getDomain());

		// put the page line count id to parameters table.
		if (pm.getParameter("_pagelines") == null)
			pm.setParameter("_pagelines", 10);

		String parentId = pm.getParameterAsString("parentId");
		if (!StringUtil.isBlank(parentId)) {
			pm.setParameter("relateid", parentId);
			pm.setParameter("parentid", parentId);
		}
		String parentid = pm.getParameterAsString("parentid");
		if (!StringUtil.isBlank(parentid)) {
			pm.setParameter("relateid", parentid);
			pm.setParameter("parentId", parentid);
		}

		String isRelate = pm.getParameterAsString("isRelate");
		if (StringUtil.isBlank(isRelate) || !"true".equals(isRelate)) {
			pm.removeParameter("parentId");
			pm.removeParameter("parentid");
		}

		return pm;
	}

	/**
	 * Get the domain.
	 * 
	 * @return The domain.
	 */
//	public String getDomain() {
//		if (StringUtils.isNotBlank(domain))
//			return domain;
//		try {
//			return getUser().getDomainid();
//		} catch (Exception e) {
//			e.printStackTrace();
//		}
//		return "";
//	}

	protected Resource success(String errmsg, Object data) {
		return new Resource(0, errmsg, data, null);
	}

	protected Resource error(int errcode, String errmsg, Collection<ErrorMessage> errors) {
		return new Resource(errcode, errmsg, null, errors);
	}

	private Resource resourceValue;

	public Resource getResourceValue() {
		return resourceValue;
	}

	public void setResourceValue(Resource resourceValue) {
		this.resourceValue = resourceValue;
	}

	/**
	 * 资源未找到的异常，返回404的状态，且返回错误信息。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(ResourceNotFoundException.class)
	@ResponseStatus(HttpStatus.NOT_FOUND)
	public Resource resourceNotFound(ResourceNotFoundException e) {
		return error(404, "Not Found", null);
	}

	/**
	 * 运行时异常，服务器错误，返回500状态，返回服务器错误信息。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(RuntimeException.class)
	@ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
	public Resource error(RuntimeException e) {
		e.printStackTrace();
		return error(500, "Server Error", null);
	}

	/**
	 * 资源未找到的异常，返回404的状态，且返回错误信息。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(OBPMValidateException.class)
	@ResponseStatus(HttpStatus.INTERNAL_SERVER_ERROR)
	public Resource serverError(OBPMValidateException e) {
		e.printStackTrace();
		return error(500, "Server Error", null);
	}

	/**
	 * 传参错误。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(MethodArgumentTypeMismatchException.class)
	@ResponseStatus(HttpStatus.NOT_ACCEPTABLE)
	public Resource resourceNotFound(MethodArgumentTypeMismatchException e) {
		return error(40035, "不合法的参数", null);
	}

	/**
	 * 请求包体解析错误。
	 * 
	 * @param e
	 * @return
	 */
	@ExceptionHandler(PathNotFoundException.class)
	@ResponseStatus(HttpStatus.NOT_ACCEPTABLE)
	public Resource requestbodyError(PathNotFoundException e) {
		e.printStackTrace();
		return error(406, "请求包体参数出错", null);
	}

    /*
     *
     *
     * json包体转对象
     *
     * */
    public Object json2obj(JSONObject json, Class c) throws Exception{
        Object o =c.newInstance();
        final Map<String, Class<?>> fieldsMap = getObjectToMap(o);
//        c.getSuperclass().getDeclaredFields();
//        Field[] fields = c.getDeclaredFields();
        Iterator<Map.Entry<String,Class<?>>> it = fieldsMap.entrySet().iterator();
        while (it.hasNext()){
            final Map.Entry<String, Class<?>> next = it.next();
            Object value = json.get(next.getKey());
            boolean flag =false;
            if(value instanceof Integer){
                flag = true;
                value = (int)value;
            }else if(value instanceof String){
                flag = !StringUtil.isBlank((String) value);
                value = (String)value;
            }else if(value instanceof Boolean){
                flag =true;
                value = (Boolean)value;
            }if(next.getValue().toString().equals("class java.util.Date")){
                if(value!=null&&!StringUtil.isBlank(value.toString())){
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    value = format.parse(value.toString());
                }
            }
            if(flag){

                Method method = c.getMethod("set" + next.getKey().substring(0, 1).toUpperCase() + next.getKey().substring(1),
                        next.getValue());
//                fields[i].setAccessible(true);
//                fields[i].set(o, value);
                method.invoke(o,value);
            }
        }
        return o;
    }
	public static Map<String,Class<?>> getObjectToMap(Object t) throws IllegalAccessException {
		Class className = t.getClass();
		Map<String,Class<?>> param=new HashMap<>();
		for(; className != Object.class ; className = className.getSuperclass()) {//获取本身和父级对象
			Field[] fields = className.getDeclaredFields();//获取所有私有字段
			for (Field field : fields) {
				field.setAccessible(true);
				Class<?> type = field.getType();
				param.put(field.getName(), type);
			}
		}
		return param;
	}
}
