package cn.myapps.conf;

import cn.myapps.common.controller.Resource;
import net.sf.json.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;


@FeignClient(value = "obpm-runtime", path="${myapps.feign-path}", configuration = FeignConfig.class)
@Component
public interface UserAPI {

    @GetMapping(value = "/api/runtime/users/myprofile")
    Resource getLoginUser() throws Exception;


    @GetMapping(value = "/api/runtime/users/profile")
    Resource getUserById(@RequestParam(required = false,value = "id") String id) throws Exception;

    @GetMapping(value = "/api/runtime/{domainId}")
    JSONObject getDomainById(@PathVariable(value="domainId") String domainId) throws Exception;
}


