package cn.myapps.conf;

import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

@Component
public class FeignConfig implements RequestInterceptor {

    public static String ADMIN_TOKEN;
    public static String ACCESS_TOKEN;
    public static String DESIGNER_TOKEN;

    @Override
    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes) RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        //添加token

//        ADMIN_TOKEN = Security.getToken("Ai6hllhNjS2ull9TKGb");
        requestTemplate.header("Cookie","adminToken="+ADMIN_TOKEN+"; accessToken="+ACCESS_TOKEN+"");
        requestTemplate.header("feignApi", "true");
    }
}